import java.io.*;
import java.util.*;

public class MaartenIcarus {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenIcarus().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        char[] word = reader.readLine().toCharArray();
        int n = word.length;
        if (n == 1) {
            System.out.println(0);
            return;
        }

        List<Set<Integer>> edges = new ArrayList<>(n);
        for (int i = 0; i < n; i++)
            edges.add(new HashSet<>());

        int[] previous = new int['z' + 1];
        for (int c = 'a'; c <= 'z'; c++)
            previous[c] = -1;

        for (int i = 0; i < n; i++) {
            char c = word[i];
            if (i > 0) {
                edges.get(i).add(i - 1);
                edges.get(i - 1).add(i);
            }
            if (i < n - 1) {
                edges.get(i).add(i + 1);
                edges.get(i + 1).add(i);
            }
            if (previous[c] != -1) {
                edges.get(i).add(previous[c]);
                edges.get(previous[c]).add(i);
            }
            previous[c] = i;
        }

        boolean[] visited = new boolean[n];
        Set<Integer> queue = new HashSet<>();
        queue.add(0);
        int hops = 0;
        while (true) {
            hops += 1;
            Set<Integer> nextQueue = new HashSet<>();
            for (Integer curr : queue) {
                for (Integer neigh : edges.get(curr)) {
                    if (neigh == n - 1) {
                        System.out.println(hops);
                        return;
                    }
                    if (visited[neigh])
                        continue;
                    visited[neigh] = true;
                    nextQueue.add(neigh);
                }
            }
            queue = nextQueue;
        }
    }
}
