import java.io.*;
import java.util.*;

import static java.lang.Integer.*;

public class MaartenFloodFillHashMap {

    private char[][] grid;
    private Set<Pos> todo;
    private Set<Pos> valid;

    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenFloodFillHashMap().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int h = parseInt(firstLine[0]);
        int w = parseInt(firstLine[1]);
        grid = new char[h][];
        for (int y = 0; y < h; y++) {
            grid[y] = reader.readLine().toCharArray();
        }

        valid = new HashSet<>();
        for (int y = 0; y < h; y++) {
            for (int x = 0; x < w; x++) {
                if (grid[y][x] == 'D')
                    valid.add(new Pos(x, y));
            }
        }

        todo = new HashSet<>();
        valid.forEach(Pos::exploreNeighbours);

        while (!todo.isEmpty()) {
            Iterator<Pos> iterator = todo.iterator();
            Pos currPos = iterator.next();
            iterator.remove();
            if (valid.contains(currPos))
                continue;

            for (Pos fromPos : currPos.getNeighbours()) {
                Pos toPos = fromPos.pushTo(currPos);
                if (valid.contains(toPos) && fromPos.tile() != '#') {
                    valid.add(currPos);
                    currPos.exploreNeighbours();
                }
            }
        }

        char[][] res = new char[h][w];
        for (char[] row : res) {
            Arrays.fill(row, 'X');
        }
        for (Pos pos : valid) {
            res[pos.y][pos.x] = 'O';
        }
        for (char[] row : res) {
            System.out.println(String.valueOf(row));
        }
    }

    class Pos {
        int x, y;

        Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        char tile() {
            return grid[y][x];
        }

        Iterable<Pos> getNeighbours() {
            ArrayList<Pos> neighbours = new ArrayList<>();
            neighbours.add(new Pos(x, y + 1));
            neighbours.add(new Pos(x, y - 1));
            neighbours.add(new Pos(x + 1, y));
            neighbours.add(new Pos(x - 1, y));
            return neighbours;
        }

        void exploreNeighbours() {
            for (Pos neighbour : getNeighbours()) {
                if (neighbour.tile() == '.' && !valid.contains(neighbour))
                    todo.add(neighbour);
            }
        }

        Pos pushTo(Pos to) {
            return new Pos(to.x + to.x - this.x, to.y + to.y - this.y);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Pos pos = (Pos) o;
            return x == pos.x && y == pos.y;
        }

        @Override
        public int hashCode() {
            return Objects.hash(x, y);
        }
    }
}
