MOD = 313109
fact = [1] * (MOD + 1)
for i in range(2, MOD + 1):
    fact[i] = (fact[i - 1] * i) % MOD


# https://stackoverflow.com/a/33634773
# n choose m modulo MOD
# computed with the theorem of Lucas
def modbinom(n, m):
    if m == 0:
        return 1

    # check for the likely case that the result is zero
    if n < m:
        return 0

    result = 1
    while n >= MOD or m >= MOD:
        if n % MOD < m % MOD:
            return 0
        result = (result * modbinom(n % MOD, m % MOD)) % MOD
        n //= MOD
        m //= MOD

    # avoid unnecessary computations
    if m > n - m:
        m = n - m

    return (((result * fact[n]) % MOD) * pow((fact[n - m] % MOD * fact[m]) % MOD, MOD - 2, MOD)) % MOD


q = int(input())
for _ in range(q):
    n = int(input()) // 2
    # (nCr(2n, n) / (n+1))  modulo MOD
    print((modbinom(2 * n, n) * (pow((n + 1) % MOD, MOD - 2, MOD))) % MOD)
