PMAX = 313109
fact = [0] * (PMAX + 5)


def lg_put(base, exp):
    res = 1;
    while (exp > 0):
        if (exp & 1):
            res = (res * base) % PMAX;
        base = (base * base) % PMAX;
        exp = exp >> 1;
    return res % PMAX;


def precalc():
    fact[0] = 1;
    fact[1] = 1;
    for i in range(2, PMAX + 1):
        fact[i] = (fact[i - 1] * i) % PMAX;


def comb(n, k, p):
    res = 1
    while (n > 0 or k > 0):
        if (n % p < k % p):
            return 0;
        fn = fact[n % p];
        fk = fact[(n - k) % p];
        fnk = fact[k % p];
        fk = lg_put(fk, p - 2);
        fnk = lg_put(fnk, p - 2);
        res = (res * fn) % p;
        res = (res * fk) % p;
        res = (res * fnk) % p;
        n = n // p;
        k = k // p;
    return res;


def catalan(n):
    a = 2 * n;
    b = comb(a, n, PMAX);
    a = lg_put((n + 1) % PMAX, PMAX - 2);
    return ((b * a) % PMAX);


def main():
    q = int(input())
    precalc();
    for _ in range(q):
        n = int(input())
        n = n >> 1;
        print(catalan(n))


if __name__ == '__main__':
    main()
