import java.io.*;
import java.util.*;

public class MaartenFraud {
    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenFraud().run(sc);
        }
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        sc.nextLine();

        String[][] code1 = new String[n][];
        String[][] code2 = new String[n][];
        for (int i = 0; i < n; i++)
            code1[i] = sc.nextLine().replaceFirst("^ +", "").split(" +");
        for (int i = 0; i < n; i++)
            code2[i] = sc.nextLine().replaceFirst("^ +", "").split(" +");

        for (int i = 0; i < n; i++) {
            // If some lines have different lengths, it's not fraud
            if (code1[i].length != code2[i].length) {
                System.out.println(-1);
                return;
            }
        }

        Map<String, String> mapper = new HashMap<>();
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < code1[i].length; j++) {
                String word1 = code1[i][j];
                String word2 = code2[i][j];
                if (mapper.containsKey(word1) && !mapper.get(word1).equals(word2)) {
                    System.out.println(-1);
                    return;
                } else {
                    mapper.put(word1, word2);
                }
            }
        }

        // If some words map to the same word, it's not fraud
        if (mapper.size() != new HashSet<>(mapper.values()).size()) {
            System.out.println(-1);
            return;
        }

        // Only print non-equal mapped words
        mapper.entrySet().removeIf(e -> e.getKey().equals(e.getValue()));

        System.out.println(mapper.size());
        mapper.entrySet().stream().sorted(Map.Entry.comparingByKey())
                .forEach(e -> System.out.println(e.getKey() + " " + e.getValue()));
    }

}
