#!/usr/bin/env python3

[h, w, l] = [int(i) for i in input().split()]
original_city_map = [[int(i) for i in input().split()] for _ in range(h)]
city_map = [[0 for i in range(w - l + 1)] for _ in range(h - l + 1)]
for y in range(h - l + 1):
    for x in range(w - l + 1):
        city_map[y][x] = max(max(original_city_map[j][x:x + l]) for j in range(y, y + l))


def can_reach(current_height):
    seen = {(0, 0)}
    todo = [(0, 0)]
    while todo:
        x, y = todo.pop()
        for new_pos in [(x - 1, y), (x + 1, y), (x, y - 1), (x, y + 1)]:
            if new_pos in seen:
                continue
            seen.add(new_pos)
            i, j = new_pos
            if i < 0 or j < 0 or i >= w - l + 1 or j >= h - l + 1:
                continue
            if city_map[j][i] > current_height:
                continue
            if i == w - l and j == h - l:
                return True
            todo.append((i, j))
    return False


# print(city_map)
low = 0
high = 1_000_000_000
while low < high:
    mid = (high + low) // 2
    if can_reach(mid):
        high = mid
    else:
        low = mid + 1

print(high + 1)
