// Solution by team Phoenix (1st place in spectators).
// Solution submitted after 61 minutes.
//package A;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;

public class A_Phoenix {
    public static void main(String[] args) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
//        BufferedReader bf = new BufferedReader(new FileReader(new File("X:\\Documents\\tud\\fpc-2020\\samples\\A\\1.in")));

        new A_Phoenix().solve(bf);
    }

    class Tuple implements Comparable<Tuple> {
        int x, y, height;

        public Tuple(int x, int y, int height) {
            this.x = x;
            this.y = y;
            this.height = height;
        }

        @Override
        public int compareTo(Tuple o) {
            return this.height - o.height;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Tuple)) return false;
            Tuple tuple = (Tuple) o;
            return x == tuple.x &&
                    y == tuple.y;
        }

        @Override
        public int hashCode() {
            return Objects.hash(x, y);
        }
    }

    private void solve(BufferedReader bf) throws Exception {
        String[] split = bf.readLine().split(" ");
        int h = Integer.parseInt(split[0]);
        int w = Integer.parseInt(split[1]);
        int s = Integer.parseInt(split[2]);

        int[][] heights = new int[h][w];
        for (int y = 0; y < h; y++) {
            split = bf.readLine().split(" ");
            for (int x = 0; x < w; x++) {
                heights[y][x] = Integer.parseInt(split[x]);
            }
        }

// Special dijkstra on the heights grid
        PriorityQueue<Tuple> queue = new PriorityQueue<>();
        queue.add(new Tuple(0, 0, 0));
        Set<Tuple> visited = new HashSet<>();
        while (!queue.isEmpty()) {
            Tuple cur = queue.poll();
            if (visited.contains(cur)) {
                continue;
            }
            if (cur.x == w - s && cur.y == h -s) {
                System.out.println(cur.height + 1);
                return;
            }
            visited.add(cur);

            // North
            if (cur.y > 0) {
               int new_y = cur.y - 1;
               if (!visited.contains(new Tuple(cur.x, new_y, 0))) {
                  int new_height = cur.height;
                  for (int x = cur.x; x < cur.x + s ; x++) {
                      new_height = Math.max(new_height, heights[new_y][x]);
                  }
                  queue.add(new Tuple(cur.x, new_y, new_height));
               }
            }

            // South
            if (cur.y < h - s) {
                int new_y = cur.y + 1;
                if (!visited.contains(new Tuple(cur.x, new_y, 0))) {
                    int new_height = cur.height;
                    for (int x = cur.x; x < cur.x + s ; x++) {
                        new_height = Math.max(new_height, heights[new_y + s -1][x]);
                    }
                    queue.add(new Tuple(cur.x, new_y, new_height));
                }
            }

            // East
            if (cur.x > 0) {
                int new_x = cur.x - 1;
                if (!visited.contains(new Tuple(new_x, cur.y, 0))) {
                    int new_height = cur.height;
                    for (int y = cur.y; y < cur.y + s; y++) {
                        new_height = Math.max(new_height, heights[y][new_x]);
                    }
                    queue.add(new Tuple(new_x, cur.y, new_height));
                }
            }

            // West
            if (cur.x < w - s) {
                int new_x = cur.x + 1;
                if (!visited.contains(new Tuple(new_x, cur.y, 0))) {
                    int new_height = cur.height;
                    for (int y = cur.y; y < cur.y + s; y++) {
                        new_height = Math.max(new_height, heights[y][new_x + s -1]);
                    }
                    queue.add(new Tuple(new_x, cur.y, new_height));
                }
            }

        }
    }
}
