#!/usr/bin/env python3

n = int(input())
program = [input().split() for _ in range(n)]
variables = {"acc": 0, "cmp": 0, "out": 0}
pc = 0


def value_of(arg):
    if arg[0] == "$":
        return variables[arg[1:]]
    else:
        return int(arg)


while 0 <= pc < n:
    opcode, arg1, arg2 = program[pc]
    if opcode == "mov":
        variables[arg2[1:]] = value_of(arg1)
        pc += 1
    elif opcode == "add":
        variables["acc"] = value_of(arg1) + value_of(arg2)
        pc += 1
    elif opcode == "sub":
        variables["acc"] = value_of(arg1) - value_of(arg2)
        pc += 1
    elif opcode == "jeq":
        if variables["cmp"] == value_of(arg1):
            pc = value_of(arg2)
        else:
            pc += 1
    elif opcode == "hcf":
        print(" ".join([opcode, arg1, arg2]))
        print(variables["acc"])
        print(variables["cmp"])
        print(variables["out"])
        exit()

print(variables["out"])
