#!/usr/bin/env python3

[n, m] = [int(i) for i in input().split()]
edges = [set() for _ in range(n + 1)]
for _ in range(m):
    [a, b] = [int(i) for i in input().split()]
    edges[a].add(b)
    edges[b].add(a)

# singletons = {i for i in range(1, n + 1) if len(edges[i]) == 1}
# while singletons:
#     current = singletons.pop()
#     if not edges[current]:
#         continue
#     neighbour: int = edges[current].pop()
#     edges[neighbour].remove(current)
#     if len(edges[neighbour]) == 1:
#         singletons.add(neighbour)
#
seen = dict()
todo = {i for i in range(1, n + 1) if edges[i]}

while todo:
    start = todo.pop()
    seen[start] = 0
    stack = [start]
    while stack:
        current = stack.pop()
        for neighbour in edges[current]:
            if neighbour in seen:
                if seen[neighbour] == seen[current]:
                    print(3)
                    exit()
            else:
                seen[neighbour] = 1 - seen[current]
                stack.append(neighbour)
                if neighbour in todo:
                    todo.remove(neighbour)

print(2)
