import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class Recursive_quadratic {

    ArrayList<Tree> list = new ArrayList<>();

    static class Tree {
        int value;
        List<Tree> children;

        Tree(int value) {
            this.value = value;
            this.children = new ArrayList<>();
        }
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        Recursive_quadratic sol = new Recursive_quadratic();
        sol.solve(sc);
        sc.close();
    }

    public Tree readTree(Scanner sc) {
        int val = sc.nextInt();
        int nbChildren = sc.nextInt();
        Tree current = new Tree(val);
        for (int i = 0; i < nbChildren; i++) {
            current.children.add(readTree(sc));
        }
        list.add(current);
        return current;
    }

    public long solve(Scanner sc) {
        int n = sc.nextInt();
        readTree(sc);
        List<Long> maxList = new ArrayList<>();
        for (Tree tree : list) {
            maxList.add(maxSum(tree));
        }
        // Phoenix' solotion makes the time limit too high, so do the loop again to become slow
        for (Tree tree : list) {
            maxList.add(maxSum(tree));
        }
        long val = Collections.max(maxList);
        System.out.println(val);
        return val;
    }

    public long maxSum(Tree root) {
        int val = root.value;
        long max1 = Long.MIN_VALUE;
        long max2 = Long.MIN_VALUE;
        for (Tree t : root.children) {
            long sum = maxPath(t);
            if (sum > max1) {
                max2 = max1;
                max1 = sum;
            } else if (sum > max2) {
                max2 = sum;
            }
        }
        max1 = Math.max(max1, 0);
        max2 = Math.max(max2, 0);
        return val + max1 + max2;
    }

    public long maxPath(Tree root) {
        int val = root.value;
        long max1 = Long.MIN_VALUE;
        for (Tree t : root.children) {
            long sum = maxPath(t);
            if (sum > max1) {
                max1 = sum;
            }
        }

        max1 = Math.max(max1, 0);

        return val + max1;
    }
}

