import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;

public class Generator {

    public static final int maxHeight = 1000;
    public static final int maxNodes = 1000000;

    public static void main(String[] args) throws IOException {
        generateRandomChain(maxHeight, Integer.MIN_VALUE, Integer.MAX_VALUE - 1, "randomValues");
        generateRandomChain(maxHeight, Integer.MAX_VALUE / 10, Integer.MAX_VALUE - 1, "highValues");
        generateRandomChain(maxHeight, Integer.MIN_VALUE, Integer.MIN_VALUE, "smallValues");
        generateRandomChain(maxHeight, Integer.MIN_VALUE, 0, "root_0");
        generateChainWithZeroSum(maxHeight);
        generateWide(maxNodes - 1, 0, Integer.MIN_VALUE, Integer.MAX_VALUE - 1, "big");
        generateWide(maxNodes - 1, 0, -100, 100, "small");
        generateWide(maxNodes - 1, -100, -maxNodes, maxNodes, "negative_root");
        generateWideChain(1000, 0, 1000);
//        generateWideChain(1000, 0, 1000);
    }

    public static void generateRandomChain(int height, int smallestValue, int highestValue, String ext) throws IOException {
        String filename = "data/secret/chain_" + height + "_" + ext;
        FileWriter file = new FileWriter(filename + ".in");
        file.write(height + "\n");
        for (int i = 0; i < height - 1; i++) {
            if (highestValue == 0 && i == 0)
                file.write("0 1\n");
            else
                file.write(ThreadLocalRandom.current().nextLong(smallestValue, highestValue + 1) + " 1\n");
        }
        file.write(ThreadLocalRandom.current().nextLong(smallestValue, highestValue + 1) + " 0\n");
        file.close();
        long answer = new RecursiveSolution().solve(new Scanner(new File(filename + ".in")));
        file = new FileWriter(filename + ".ans");
        file.write(Long.toString(answer) + "\n");
        file.close();
    }

    public static void generateChainWithZeroSum(int height) throws IOException {
        String filename = "data/secret/zero_chain_" + height;
        FileWriter file = new FileWriter(filename + ".in");
        file.write(height + "\n");
        for (int i = 0; i < height - 1; i++) {
            file.write("-1 1\n");
        }
        file.write(height + " 0\n");
        file.close();
        long answer = new RecursiveSolution().solve(new Scanner(new File(filename + ".in")));
        file = new FileWriter(filename + ".ans");
        file.write(Long.toString(answer) + "\n");
        file.close();
    }

    public static void generateWide(int width, int rootValue, int smallestValue, int highestValue, String ext) throws IOException {
        String filename = "data/secret/wide_" + (width + 1) + "_" + ext;
        FileWriter file = new FileWriter(filename + ".in");
        file.write((width + 1) + "\n");
        file.write(rootValue + " " + width + "\n");
        for (int i = 0; i < width; i++) {
            file.write(ThreadLocalRandom.current().nextLong(smallestValue, highestValue + 1) + " 0\n");
        }
        file.close();
        long answer = new RecursiveSolution().solve(new Scanner(new File(filename + ".in")));
        file = new FileWriter(filename + ".ans");
        file.write(Long.toString(answer) + "\n");
        file.close();
    }

    public static void generateWideChain(int width, int rootValue, int height) throws IOException {
        String filename = "data/secret/wide_chain_width_" + width + "_height_" + height;
        FileWriter file = new FileWriter(filename + ".in");
        file.write((width * height) + "\n");
        file.write(rootValue + " " + width + "\n");
        for (int i = 0; i < width; i++) {
            for (int j = 0; j < height - 1; j++) {
                if (i == width - 1 && j == height - 2)
                    continue;
                file.write(ThreadLocalRandom.current().nextLong(-100, 101) + " 1\n");
            }
            file.write(ThreadLocalRandom.current().nextLong(-100, 101) + " 0\n");
        }
        file.close();
        long answer = new RecursiveSolution().solve(new Scanner(new File(filename + ".in")));
        file = new FileWriter(filename + ".ans");
        file.write(Long.toString(answer) + "\n");
        file.close();
    }

}
