import java.io.*;
import java.util.*;

public class GenerateTrees {

    static Random random = new Random(538746352);

    static int[][] problems = {
            // n
            {20},
            {100},
            {1000},
            {10_000},
            {100_000},
    };

    public static void main(String[] args) throws IOException {
        for (int[] problem : problems) {
            write(generateTree(problem), problemName(problem));
        }
        int maxSize = problems[problems.length - 1][0];
        write(generateList(maxSize), "n_" + maxSize + "_list");
        write(generateWide(maxSize), "n_" + maxSize + "_super_wide");
        write(generateWideList(maxSize), "n_" + maxSize + "_wide_and_long");
        write(generateBinary(maxSize - 1), "n_" + (maxSize - 1) + "_binary");
    }

    private static void write(String problem, String name) throws IOException {
        long answer = new F_Correct().calculateWidth(new Scanner(problem));
        FileWriter file = new FileWriter("../data/secret/" + name + ".in");
        file.write(problem);
        file.close();
        file = new FileWriter("../data/secret/" + name + ".ans");
        file.write(answer + "\n");
        file.close();
    }

    private static String generateList(int n) {
        String[] names = generateNames(n);
        List<String> tree = new ArrayList<>();
        for (int i = 0; i < n - 1; i++) {
            tree.add(names[i] + " - " + names[i + 1]);
        }
        return treeToString(n, names[0], tree);
    }

    private static String generateWide(int n) {
        String[] names = generateNames(n);
        List<String> tree = new ArrayList<>();
        for (int i = 1; i < n; i++) {
            tree.add(names[0] + " - " + names[i]);
        }
        return treeToString(n, names[0], tree);
    }

    private static String generateWideList(int n) {
        String[] names = generateNames(n);
        List<String> tree = new ArrayList<>();
        int i;
        for (i = 1; i < n / 2; i++) {
            tree.add(names[0] + " - " + names[i]);
        }
        for (--i; i < n - 1; i++) {
            tree.add(names[i] + " - " + names[i + 1]);
        }
        return treeToString(n, names[0], tree);
    }

    private static String generateBinary(int n) {
        String[] names = generateNames(n);
        List<String> tree = new ArrayList<>();
        for (int i = 0; i < n / 2; i++) {
            tree.add(names[i] + " - " + names[2 * i + 1]);
            tree.add(names[i] + " - " + names[2 * i + 2]);
        }
        return treeToString(n, names[0], tree);
    }

    private static String generateTree(int[] problem) {
        int n = problem[0];
        String[] names = generateNames(n);

        List<String> tree = new ArrayList<>();
        int from = 0, to = 1;
        while (to < n) {
            int children = random.nextInt(10);
            int max = Math.min(n, to + children);
            while (to < max) {
                tree.add(names[from] + " - " + names[to]);
                to++;
            }
            from++;
        }
        return treeToString(n, names[0], tree);
    }

    private static String[] generateNames(int n) {
        Set<String> teamsSet = new HashSet<>(n);
        while (teamsSet.size() < n) {
            teamsSet.add(random.ints('A', 'z' + 1)
                    .filter(c -> c <= 'Z' || c >= 'a')
                    .limit(random.nextInt(20) + 1)
                    .collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append)
                    .toString());
        }
        return teamsSet.toArray(new String[0]);
    }

    private static String treeToString(int n, String name, List<String> tree) {
        Collections.shuffle(tree, random);

        StringBuilder sb = new StringBuilder();
        sb.append(n).append('\n').append(name).append('\n');
        for (String s : tree) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    private static String problemName(int[] problem) {
        return "n_" + problem[0];
    }
}
