import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.Stack;

public class F_Correct {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new F_Correct().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        long l = calculateLength(sc);
        System.out.println(l);
    }

    public long calculateLength(Scanner sc) {
        int n = sc.nextInt();
        int e = sc.nextInt();
        int[] entrances = new int[e];
        for (int i = 0; i < e; i++) {
            entrances[i] = sc.nextInt();
        }
        int[][] forest = new int[n + 1][0];
        int[] parent = new int[n + 1];
        for (int i = 1; i <= n; i++) {
            int children = sc.nextInt();
            forest[i] = new int[children];
            for (int j = 0; j < children; j++) {
                forest[i][j] = sc.nextInt();
                parent[forest[i][j]] = i;
            }
        }
        long ans = 0;
        for (int entrance : entrances) {
            ans += iterativeCount(entrance, forest, parent).l;
        }
        return ans * 2;
    }

    private Dimensions iterativeCount(int entrance, int[][] forest, int[] parent) {
        if (forest[entrance].length == 0) {
            return new Dimensions(1, 0);
        }
        Dimensions[] dimensions = new Dimensions[forest.length];
        Stack<Integer> stack = new Stack<>();
        stack.add(entrance);
        dimensions[entrance] = new Dimensions(0, 0);
        int[] children = new int[forest.length];
        children[entrance] = forest[entrance].length;
        children[0] = -1;
        while (!stack.isEmpty()) {
            Integer current = stack.pop();

            boolean skip = false;
            while (children[current] == 0 && current != entrance) {
                skip = true;
                int p = parent[current];
                Dimensions dp = dimensions[p];
                Dimensions dc = dimensions[current];
                dp.l += dc.w + dc.l;
                dp.w += dc.w;
                children[p]--;
                current = p;
            }
            if (skip)
                continue;

            for (int child : forest[current]) {
                stack.add(child);
                children[child] = forest[child].length;
                if (forest[child].length == 0) {
                    dimensions[child] = new Dimensions(1, 0);
                } else {
                    dimensions[child] = new Dimensions(0, 0);
                }
            }
        }
        long w = 0, l = 0;
        for (int child : forest[entrance]) {
            Dimensions d = dimensions[child];
            l += d.w + d.l;
            w += d.w;
        }
        return new Dimensions(w, l);
    }

    static class Dimensions {
        long w, l;

        public Dimensions(long w, long l) {
            this.w = w;
            this.l = l;
        }

        @Override
        public String toString() {
            return "{" +
                    "w=" + w +
                    ", l=" + l +
                    '}';
        }
    }
}
