import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class H_Correct {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new H_Correct().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        List<Integer> path = calculatePath(sc);
        System.out.println(path.size());
    }

    List<Integer> calculatePath(Scanner sc) {
        int n = sc.nextInt();
        int m = sc.nextInt();
        int s = sc.nextInt();

        boolean[] shrooms = new boolean[n + 1];
        shrooms[1] = shrooms[n] = true;
        for (int i = 0; i < s - 2; i++) {
            shrooms[sc.nextInt()] = true;
        }

        Intersection[] intersections = new Intersection[n + 1];
        for (int i = 1; i <= n; i++) {
            intersections[i] = new Intersection(i);
        }

        for (int i = 0; i < m; i++) {
            int a = sc.nextInt();
            int b = sc.nextInt();
            if (!shrooms[a] || !shrooms[b])
                continue; // Only add roads between intersections that have shrooms
            intersections[a].neighbours.add(intersections[b]);
            intersections[b].neighbours.add(intersections[a]);
        }

        int[] previous = new int[n + 1];
        previous[1] = -1;
        Queue<Intersection> queue = new LinkedList<>();
        queue.add(intersections[1]);
        while (!queue.isEmpty()) {
            Intersection intersection = queue.poll();
            for (Intersection neighbour : intersection.neighbours) {
                if (previous[neighbour.id] != 0)
                    continue; // We have already explored this intersection
                queue.add(neighbour);
                previous[neighbour.id] = intersection.id;
                if (neighbour.id == n) {
                    queue.clear();
                    break;
                }
            }
        }

        LinkedList<Integer> path = new LinkedList<>();
        path.add(n);
        while (path.getFirst() != 1) {
            path.addFirst(previous[path.getFirst()]);
        }
        return path;
    }

    static class Intersection {
        public final int id;
        public List<Intersection> neighbours = new ArrayList<>();

        Intersection(int id) {
            this.id = id;
        }
    }
}
