#!/usr/bin/env python3

from queue import Queue
from typing import List

line = input().split(" ")
n = int(line[0])
m = int(line[1])
s = int(line[2])

shrooms = [False for _ in range(n + 1)]
shrooms[1] = shrooms[n] = True

if s > 2:
    for l in input().split(" "):
        shrooms[int(l)] = True
else:
    input()  # Read empty line

intersections = [[] for _ in range(n + 1)]

for _ in range(m):
    line = input().split(" ")
    a = int(line[0])
    b = int(line[1])
    if not shrooms[a] or not shrooms[b]:
        continue
    intersections[a].append(b)
    intersections[b].append(a)

previous = [0 for _ in range(n + 1)]
queue = Queue()
queue.put(1)
while not queue.empty():
    intersection = queue.get()
    neighbours = intersections[intersection]
    for neighbour in neighbours:
        if previous[neighbour] != 0:
            continue  # We have already explored this intersection
        queue.put(neighbour)
        previous[neighbour] = intersection
        if neighbour == n:
            queue = Queue()  # Clear queue to break out of the outer loop

path = [n]
while path[-1] != 1:
    path.append(previous[path[-1]])
path.reverse()

print(len(path))
