import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Scanner;

public class GuessGameRunjury {
	public static void main(String[] args) throws FileNotFoundException{
		if (args.length != 2) {
			System.err.printf("error: invalid number of arguments: %d, while 2 expected\n", args.length);
			for(int j = 0; j < args.length;j++){ 
				System.err.printf(" arg %d = %s\n", j, args[j]);
			}
			System.exit(1);
		}
		for(int i = 2; i < args.length;i++){
			System.err.printf("Extra arg %d = %s\n", i, args[i]);
		}
		InputStream dataInSteam = null;
		OutputStream progOutStream = null;
		
		try{
			dataInSteam = new FileInputStream(args[0]);
			progOutStream = new FileOutputStream(args[1]);
		} catch(IOException e){
			System.err.printf("error: could not open input and/or output file\n");
			System.exit(1);
		}
		PrintStream progOut = new PrintStream(progOutStream);
		Scanner dataIn = new Scanner(dataInSteam);
		Scanner systemIn = new Scanner(System.in);
		if (!dataIn.hasNextInt()) {
			System.err.printf("error: failed to read number to guess\n");
			System.exit(1);
		}
		int target = dataIn.nextInt();
		// start talking
		boolean talking = true;
		long start = System.currentTimeMillis();
		long errors = 0;
		long prints = 0;
		long requests = 0;
		while(talking && System.currentTimeMillis() - start <= 5000){
			String line = null;
			try{
				line = systemIn.nextLine();
			} catch(Exception e){
				if(errors++ < 25){
					System.err.println("Can't read line: "+e+", ex="+systemIn.ioException());
				}
			}
			requests++;
			if(++prints < 1000) System.err.println("Received "+line);
			else if (prints == 1000) System.err.println("Further lines read not printed.");
			if(line != null){
				progOut.println(line);
				Scanner sc = new Scanner(line);
				String op = sc.next();
				if("ASK".equals(op)){
					if(!sc.hasNext()){
						System.err.printf("error: ASK not followed by value: %s\n", line);
					} else{
						String val = sc.next();
						// verify its an integer
						boolean validInteger = true;
						for(int i = 0; validInteger && i < val.length();i++){
							if(!Character.isDigit(val.charAt(i))) validInteger = false;
						}
						if(!validInteger){
							System.err.printf("error: ASK not followed by integer: %s\n", line);
						} else {
							BigInteger x = new BigInteger(val);
							int cmp = x.compareTo(BigInteger.valueOf(target));
							if(cmp == 0){
								System.out.println("GAME");
							} else if(cmp > 0){
								System.out.println("LOWER");
							} else{
								System.out.println("HIGHER");
							}
						}
					}
				} else if("OVER".equals(op)){
					talking = false;
				} else{
					System.err.printf("output doesn't contain valid operation: %s\n", line);
				}
			}
		}
		progOut.println("TARGET "+target);
		while(systemIn.hasNextLine()){
			String x = systemIn.nextLine();
			progOut.println(x);
		}
		System.err.println("Runjury completed in "+(System.currentTimeMillis() - start)+" ms processing "+requests+" requests.");
		try{
			dataInSteam.close();
			progOutStream.close();
		} catch(IOException e){
			System.err.println("Could not close file streams");
		}
	}
}
