#include <iostream>
#include <unordered_map>

using namespace std;

struct Pos {
    int x, y;
};

void calculateBingo(int n, int m, string **grid, string *events) {
    if (n == 1) {
        cout << "0" << endl;
        return;
    }
    unordered_map<string, Pos> map;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            map[grid[i][j]] = {i, j};
        }
    }
    int rows[n], cols[n], diag[] = {1, 1};
    for (int i = 0; i < n; i++) {
        rows[i] = 0;
        cols[i] = 0;
    }
    rows[n / 2] = 1;
    cols[n / 2] = 1;
    for (int i = 0; i < m; i++) {
        Pos pos;
        if (!map.count(events[i])) continue;
        try {
            pos = map[events[i]];
        } catch (const out_of_range e) {
            continue;
        }
        rows[pos.x]++;
        cols[pos.y]++;
        if (pos.x == pos.y) diag[0]++;
        if (pos.x == n - pos.y - 1) diag[1]++;
        for (int j = 0; j < n; j++) {
            if (rows[j] == n || cols[j] == n) {
                cout << i + 1 << endl;
                return;
            }
        }
        for (int j = 0; j < 2; j++) {
            if (diag[j] == n) {
                cout << i + 1 << endl;
                return;
            }
        }
    }
    cout << ":-(" << endl;
}

int main(void) {
    int n, m;
    cin >> n >> m;
    string **grid = new string *[n];
    for (int i = 0; i < n; i++) {
        grid[i] = new string[n];
        for (int j = 0; j < n; j++) {
            cin >> grid[i][j];
        }
    }
    string *events = new string[m];
    for (int i = 0; i < m; i++) {
        cin >> events[i];
    }
    calculateBingo(n, m, grid, events);
    return 0;
}
