import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class B_correct {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new B_correct().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt(), m = sc.nextInt();
        String[][] grid = new String[n][n];
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                grid[i][j] = sc.next();
            }
        }
        String[] events = new String[m];
        for (int i = 0; i < m; i++) {
            events[i] = sc.next();
        }
        System.out.println(calculateBingo(n, m, grid, events));
    }

    public String calculateBingo(int n, int m, String[][] grid, String[] events) {
        if (n == 1) return "0";
        Map<String, Pos> map = new HashMap<>(n * n);
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                map.put(grid[i][j], new Pos(i, j));
            }
        }
        int[] rows = new int[n];
        int[] cols = new int[n];
        int[] diag = new int[]{1, 1};
        rows[n / 2] = 1;
        cols[n / 2] = 1;
        for (int i = 0; i < m; i++) {
            Pos pos = map.get(events[i]);
            if (pos == null) continue;
            rows[pos.x]++;
            cols[pos.y]++;
            if (pos.x == pos.y) diag[0]++;
            if (pos.x == n - pos.y - 1) diag[1]++;
            for (int j = 0; j < n; j++) {
                if (rows[j] == n || cols[j] == n) {
                    return i + 1 + "";
                }
            }
            for (int j = 0; j < 2; j++) {
                if (diag[j] == n) {
                    return i + 1 + "";
                }
            }
        }
        return ":-(";
    }

    public static class Pos {
        int x, y;

        public Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}
