import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Scanner;

public class E_BruteForce {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new E_BruteForce().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        long n = sc.nextLong();
        String nFactorial = factorial(n);
        System.out.println(countTrailingZeroes(nFactorial));
    }

    public long countTrailingZeroes(String s) {
        long j = 0;
        for (int i = s.length() - 1; i >= 0; i--, j++) {
            if (s.charAt(i) != '0') break;
        }
        return j;
    }

    /**
     * Calculate the factorial of n
     * Complexity: O(n^3 log^2 n)
     * Stirling's approximation: n! ~~ n^n e^{-n} sqrt(2 pi n)
     * So log(n!) ~~ n(log n - log e) + O(log n) is O(n log n)
     * Multiplying is O(log^2 N), with N = n!, and done n times, thus it's O(n O(n log n)^2) which is O(n^3 log^2 n)
     */
    public String factorial(long n) {
        if (n == 0) return "1";
        BigInteger f = BigInteger.valueOf(n);
        while (n > 1) {
            n--;
            f = f.multiply(BigInteger.valueOf(n));
        }
        return f.toString();
    }
}
