import java.io.BufferedInputStream;
import java.util.Locale;
import java.util.Scanner;

/**
 * Created by Laurens on 28-1-2016.
 */
public class SKP2016CWrong {

    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedInputStream(System.in));
        // Set this to read points in floats instead of commas.
        sc.useLocale(Locale.ENGLISH);
        new SKP2016CWrong().solve(sc);
    }

    // O(n^2)
    private void solve(Scanner sc) {
        int SKPLength = sc.nextInt();
        int numberOfStudents = sc.nextInt();
        float bestTimeMeasured = sc.nextFloat();

        float[] frontCrawlSpeeds = new float[numberOfStudents];
        float[] backCrawlSpeeds = new float[numberOfStudents];

        for (int i = 0; i < numberOfStudents; i++) {
            frontCrawlSpeeds[i] = sc.nextFloat();
            backCrawlSpeeds[i] = sc.nextFloat();
        }

        // Avoid devide by zero!
        float highestSpeed = 0.0000001f;

        // This was actually pretty hard to come up with.. to do a double nested loop
        // that actually made any sense at all.
        for (int i = 0; i < numberOfStudents; i++) {
            float studentSpeed = (frontCrawlSpeeds[i] + backCrawlSpeeds[i]) / 2.0f;
            for (int j = 0; j < numberOfStudents; j++) {
                // Don't compare against yourself!
                if(j == i){
                    continue;
                }
                float otherStudentSpeed = (frontCrawlSpeeds[j] + backCrawlSpeeds[j]) / 2.0f;
                if(otherStudentSpeed > studentSpeed) {
                    studentSpeed = otherStudentSpeed;
                }
            }
            if(studentSpeed > highestSpeed){
                highestSpeed = studentSpeed;
            }
        }


        // Don't forget that you have to return! 2 times the length thus.
        if ((SKPLength * 2) / highestSpeed < bestTimeMeasured) {
            System.out.println("HOPE");
        } else {
            System.out.println("DOOMED");
        }
    }
}
