import java.util.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class ragnar {

	static class Edge {
		int v;
		long w;
		Edge(int _v, long _w) {
			v = _v;
			w = _w;
		}
	};

	static int n, m, q;
	static ArrayList<Edge>[] g;
	static ArrayList<Long>[] d;
	static boolean[] b;

	static boolean dfs(int i, int u){
		for(Edge e : g[u]){
			int v = e.v;
			long w = e.w;
			long dv = d[i].get(u) ^ w;
			long div = d[i].get(v);
			if(div == -1){
				d[i].set(v, dv);
				if(! dfs(i, v)){
					return false;
				}
			} else if (((div ^ dv)&(1L<<i)) != 0L){
				long c = div ^ dv;
				for(ArrayList<Edge> s : g){
					for(Edge f : s){
						if((f.w & (1L<<i)) != 0L)
							f.w = f.w ^ c;
					}
				}
				return false;
			}
		}
		return true;
	}

	public static void main(String[] args) throws IOException {
		BufferedReader br = new BufferedReader( 
				new InputStreamReader(System.in));
		{
			StringTokenizer st = new StringTokenizer(br.readLine());
			n = Integer.parseInt(st.nextToken());
			m = Integer.parseInt(st.nextToken());
			q = Integer.parseInt(st.nextToken());
		}

		g = new ArrayList[n];
		for(int i = 0; i < n; ++i){
			g[i] = new ArrayList();
		}

		for(int i = 0; i < m; ++i){
			StringTokenizer st = new StringTokenizer(br.readLine());
			int u = Integer.parseInt(st.nextToken());
			int v = Integer.parseInt(st.nextToken());
			long w = Long.parseLong(st.nextToken());
			g[u-1].add(new Edge(v-1, w));
			g[v-1].add(new Edge(u-1, w));
		}

		d = new ArrayList[64];
		for(int i = 0; i < 64; ++i){
			d[i] = new ArrayList<Long>(Collections.nCopies(n, -1L));
		}

		b = new boolean[64];
		for(int j = 0; j < 64; ++j){
			b[j] = false;
		}

		for(int i = 63; i >= 0; --i){
			d[i].set(0, 0L);
			b[i] = dfs(i, 0);
		}

		for(int qi = 0; qi < q; ++qi){
			StringTokenizer st = new StringTokenizer(br.readLine());
			int x = Integer.parseInt(st.nextToken()) - 1;
			int y = Integer.parseInt(st.nextToken()) - 1;
			long a = 0;
			for(int i = 63; i >= 0; --i){
				if(b[i]){
					a += (d[i].get(x)^d[i].get(y))&(1L<<i);
				}
			}
			System.out.println(a);
		}


	}
}
