#include <algorithm>
#include <bitset>
#include <cassert>
#include <chrono>
#include <cstring>
#include <iomanip>
#include <iostream>
#include <map>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <vector>

using namespace std;

typedef pair<int, int> pii;
typedef pair<pii, int> state;

const int MOD = 11092019;
const int SEGTREE_SZ = 1 << 20;
pii segtree[2 * SEGTREE_SZ];

inline pii merge(pii a, pii b) {
  if(a.first > b.first) return a;
  if(b.first > a.first) return b;
  return {a.first, (a.second + b.second) % MOD};
}

void upd(int idx, int lval, int rval) {
  idx += SEGTREE_SZ;
  rval %= MOD;
  segtree[idx] = {lval, rval};
  while(idx > 1) {
    idx /= 2;
    segtree[idx] = merge(segtree[2*idx], segtree[2*idx+1]);
  }
}
pii qry(int lhs, int rhs) {
  pii ret = {-1, -1};
  lhs += SEGTREE_SZ;
  rhs += SEGTREE_SZ;
  while(lhs <= rhs) {
    if(lhs == rhs) {
      ret = merge(ret, segtree[lhs]);
      break;
    }
    if(lhs%2) ret = merge(ret, segtree[lhs++]);
    if(rhs%2==0) ret = merge(ret, segtree[rhs--]);
    lhs /= 2;
    rhs /= 2;
  }
  return ret;
}

int label[1000005];
int par[1000005];
vector<int> children[1000005];
int n;

int treesz[1000005];
int depth[1000005];
int topofchain[1000005];
int segtreeidxmap[1000005];

pii getLIS(int curr) {
  pii best = {-1, -1};
  int orig = curr;
  while(true) {
    int topchain = topofchain[curr];
    best = merge(best, qry(segtreeidxmap[topchain], segtreeidxmap[curr]));
    if(topchain == 0) break;
    curr = par[topchain];
  }
  if(best.first == 0) best.second = 1;
  upd(segtreeidxmap[orig], ++best.first, best.second);
  return best;
}

void _dfsForHLD(int curr, int top, int& segtreeidx) {
  segtreeidxmap[curr] = segtreeidx++;
  topofchain[curr] = top;
  if(children[curr].empty()) return;
  int bestchild = children[curr][0];
  for(int out: children[curr]) {
    if(treesz[out] > treesz[bestchild]) bestchild = out;
  }
  _dfsForHLD(bestchild, top, segtreeidx);
  for(int out: children[curr]) {
    if(out != bestchild) _dfsForHLD(out, out, segtreeidx);
  }
}
void _dfsForStats(int curr) {
  treesz[curr]++;
  for(int out: children[curr]) {
    depth[out] = depth[curr+1];
    _dfsForStats(out);
    treesz[curr] += treesz[out];
  }
}
void dfsForHLD() {
  _dfsForStats(0);
  int segtreeidx = 0;
  _dfsForHLD(0, 0, segtreeidx);
}

void solve() {
  cin >> n;
  for(int i = 0; i < n; i++) {
    cin >> label[i];
  }
  for(int i = 1; i < n; i++) {
    cin >> par[i];
    children[--par[i]].push_back(i);
  }
  dfsForHLD();
  vector<state> vertices;
  for(int i = 0; i < n; i++) {
    vertices.push_back({{label[i], depth[i]}, i});
  }
  sort(vertices.begin(), vertices.end());
  pii ret = {0, 0};
  for(state out: vertices) {
    pii curr = getLIS(out.second);
    ret = merge(ret, curr);
  }
  cout << ret.first << " " << ret.second << "\n";
}

int main() {
  solve();
}
