#include <iostream>
#include <vector>
#include <algorithm>
#include <tuple>

int const MOD = 11092019;

void dfs_iterative(std::vector<std::vector<int>> const &tree, std::vector<int> const &label, std::vector<int> *length, std::vector<int> *multiplicity) {
    std::vector<std::pair<int, int>> stack = { {0, -1} };

    std::vector<std::vector<std::tuple<int, int, int>>> longest = { { {-1, 1, 0 } } };

    while (stack.size()) {
        auto [u, loc] = stack.back();
        stack.pop_back();
        auto u_lbl = label[u];

        //std::cout << (u+1) << " " << loc << " " << u_lbl << "\n";

        if (0 <= loc) {
            longest[loc].pop_back();
            if (longest[loc].size() == 1)
                longest.pop_back();
        } else {
            int lo = 1, hi = longest.size();
            while (lo < hi) {
                int mid = (lo + hi) / 2;
                if (std::get<0>(longest[mid].back()) <= u_lbl)
                    lo = mid + 1;
                else
                    hi = mid;
            }
            int x = lo;

            length->at(u) = x;
            if (x == longest.size())
                longest.push_back( { {-1, 1, 0 } } );

            lo = 1;
            hi = longest[x-1].size();
            while (lo < hi) {
                int mid = (lo + hi) / 2;
                if (std::get<0>(longest[x-1][mid]) <= u_lbl)
                    hi = mid;
                else
                    lo = mid + 1;
            }
            int y = lo;

            int m = 0;
            if (y + 1 < longest[x-1].size()) {
                auto b = std::get<2>(longest[x-1].back());
                auto a = std::get<2>(longest[x-1][y-1]);
                m = (MOD + b - a) % MOD;
            } else {
                m = std::get<1>(longest[x-1].back());
            }
            multiplicity->at(u) = m;

            longest[x].push_back({u_lbl, m, (std::get<2>(longest[x].back()) + m) % MOD});

            stack.push_back({u, x});
            for (auto v : tree[u])
                stack.push_back({v, -1});
        }
    }
}

int main() {
    int n;
    std::cin >> n;
    std::vector<int> label(n), parent(n-1);
    for (auto &l : label) std::cin >> l;
    for (auto &p : parent) std::cin >> p, p--;

    // set up our DP structures
    std::vector<int> length(n, 0);
    std::vector<int> multiplicity(n, 0);
    std::vector<std::vector<int>> tree(n);

    for (int u = 1; u < n; ++u)
        tree[parent[u-1]].push_back(u);

    dfs_iterative(tree, label, &length, &multiplicity);

    int best = *std::max_element(length.begin(), length.end());
    int count = 0;
    for (int i = 0; i < n; ++i)
        if (length[i] == best)
            count = (count + multiplicity[i]) % MOD;
    std::cout << best << " " << count << std::endl;

    /*
    for (auto x : length) { std::cerr << x << " "; }
    std::cerr << "\n";

    for (auto x : multiplicity) { std::cerr << x << " "; }
    std::cerr << "\n";
    */

    return 0;
}
