#include <bits/stdc++.h>

using namespace std;

#define all(x) begin(x), end(x)

using ll = long long;
using ld = long double;
using pii = pair<int, int>;
using vi = vector<int>;

constexpr int MAXN = 200005;
constexpr int MOD = 11092019;
int n;

int val[MAXN];
int par[MAXN];
vi tree[MAXN];

vi lis;
int dp[MAXN];
vector<pii> stk;

void dfs(int u) {
    if (lis.empty() or val[u] >= lis.back()) {
        lis.push_back(val[u]);
        stk.emplace_back(-1, -1);

        dp[u] = lis.size();
    } else {
        int idx = upper_bound(all(lis), val[u]) - begin(lis);
        stk.emplace_back(idx, lis[idx]);
        lis[idx] = val[u];

        dp[u] = idx + 1;
    }

    for (int v : tree[u]) {
        dfs(v);
    }

    pii& op = stk.back();
    if (op.first == -1) {
        lis.pop_back();
    } else {
        lis[op.first] = op.second;
    }
}

int main() {
    cin >> n;
    for (int i = 0; i < n; ++i) {
        cin >> val[i];
    }

    for (int i = 1; i < n; ++i) {
        cin >> par[i];
        --par[i];

        tree[par[i]].push_back(i);
    }

    dfs(0);

    int best = 0;
    int ways = 0;
    for (int i = 0; i < n; ++i) {
        if (dp[i] > best) {
            best = dp[i];
            ways = 0;
        }

        if (dp[i] == best) {
            ways = (ways + 1) % MOD;
        }
    }

    cout << best << ' ' << ways << '\n';

    return 0;
}
