#include <iostream>
#include <vector>
#include <algorithm>

int const MOD = 11092019;

int main() {
    int n;
    std::cin >> n;
    std::vector<int> label(n), parent(n-1);
    for (auto &l : label) std::cin >> l;
    for (auto &p : parent) std::cin >> p, p--;
    parent.insert(parent.begin(), -1);

    // set up our DP structures
    std::vector<int> longest(n, 0);
    std::vector<int> min_label(label);
    std::vector<int> length(n, 0);
    std::vector<int> multiplicity(n, 0);

    // base case: root has a path and multiplicity of 1
    length[0] = longest[0] = multiplicity[0] = 1;

    // now, go over all the children (the tree input is ordered so that all
    // ancestors of i will have finished before we consider i)
    for (int i = 1; i < n; ++i) {
        int ancestor = parent[i];
        int best = i;
        int best_mult = 0;

        while (0 <= ancestor and (length[best] <= longest[ancestor]) and (min_label[ancestor] <= label[i])) {
            if (label[ancestor] <= label[i]) {
                if (length[best] < length[ancestor]) {
                    best = ancestor;
                    best_mult = multiplicity[ancestor];
                } else if (length[best] == length[ancestor]) {
                    best_mult = (best_mult + multiplicity[ancestor]) % MOD;
                }
            }

            ancestor = parent[ancestor];
        }

        if (best != i) {
            length[i] = length[best] + 1;
            multiplicity[i] = best_mult;
        } else {
            length[i] = multiplicity[i] = 1;
        }

        longest[i] = std::max(longest[parent[i]], length[i]);
        min_label[i] = std::min(min_label[parent[i]], min_label[i]);
    }

    int best = *std::max_element(length.begin(), length.end());
    int count = 0;
    for (int i = 0; i < n; ++i) {
        if (length[i] == best) {
            count = (count + multiplicity[i]) % MOD;
        }
    }
    std::cout << best << " " << count << std::endl;

    return 0;
}

