import java.util.*;
import java.io.*;

public class JumpingpathHamerly {
    static final int MOD = 11092019;
    static final int MAX_N = 1000000;

    public static class LabelMult {
        public LabelMult(int l, int m, int s) { label = l; multiplicity = m; multiplicitySum = s; }
        public int label, multiplicity, multiplicitySum;
    }

    public static void dfs_iterative(ArrayList<ArrayList<Integer>> tree, int label[], int length[], int multiplicity[]) {
        int stack_vtx[] = new int[tree.size()];
        int stack_loc[] = new int[tree.size()];
        int top = 0;
        stack_vtx[top] = 0;
        stack_loc[top] = -1;
        top++;

        LabelMult sentinel = new LabelMult(-1, 1, 0);

        ArrayList<ArrayList<LabelMult>> longest = new ArrayList<ArrayList<LabelMult>>();
        longest.add(new ArrayList<LabelMult>());
        longest.get(0).add(sentinel);

        while (0 < top) {
            int u = stack_vtx[top-1];
            int loc = stack_loc[top-1];
            top--;
            int u_lbl = label[u];

            if (0 <= loc) {
                longest.get(loc).remove(longest.get(loc).size() - 1);
                if (longest.get(loc).size() == 1)
                    longest.remove(longest.size() - 1);
            } else {
                int lo = 1, hi = longest.size();
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (longest.get(mid).get(longest.get(mid).size() - 1).label <= u_lbl)
                        lo = mid + 1;
                    else
                        hi = mid;
                }
                int x = lo;

                length[u] = x;
                if (x == longest.size()) {
                    longest.add(new ArrayList<LabelMult>());
                    longest.get(longest.size()-1).add(sentinel);
                }

                lo = 1;
                hi = longest.get(x-1).size();
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (longest.get(x-1).get(mid).label <= u_lbl)
                        hi = mid;
                    else
                        lo = mid + 1;
                }
                int y = lo;

                int m = 0;
                int s = longest.get(x-1).size();
                if (y + 1 < s) {
                    int a = longest.get(x-1).get(s-1).multiplicitySum;
                    int b = longest.get(x-1).get(y-1).multiplicitySum;
                    m = (MOD + a - b) % MOD;
                } else {
                    m = longest.get(x-1).get(s-1).multiplicity;
                }
                multiplicity[u] = m;

                longest.get(x).add(new LabelMult(u_lbl, m, (longest.get(x).get(longest.get(x).size() - 1).multiplicitySum + m) % MOD));

                stack_vtx[top] = u;
                stack_loc[top++] = x;

                for (int v : tree.get(u)) {
                    stack_vtx[top] = v;
                    stack_loc[top++] = -1;
                }
            }
        }
    }

    public static void main(String args[]) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int n = Integer.parseInt(br.readLine());

        int label[] = new int[n];
        int parent[] = new int[n-1];

        for (int i = 0; i < n; ++i) label[i] = Integer.parseInt(br.readLine());
        for (int i = 0; i < n-1; ++i) parent[i] = Integer.parseInt(br.readLine()) - 1;

        int length[] = new int[n];
        int multiplicity[] = new int[n];

        ArrayList<ArrayList<Integer>> tree = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < n; ++i) 
            tree.add(new ArrayList<Integer>());

        for (int u = 1; u < n; ++u)
            tree.get(parent[u-1]).add(u);

        dfs_iterative(tree, label, length, multiplicity);

        int best = 0;
        for (int i = 0; i < n; ++i) {
            if (best < length[i])
                best = length[i];
        }
        int count = 0;
        for (int i = 0; i < n; ++i)
            if (length[i] == best)
                count = (count + multiplicity[i]) % MOD;
        System.out.println(best + " " + count);
    }
}
