import java.io.OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.io.BufferedWriter;
import java.util.InputMismatchException;
import java.io.IOException;
import java.util.HashSet;
import java.io.Writer;
import java.io.OutputStreamWriter;
import java.io.InputStream;

/**
 * Built using CHelper plug-in
 * Actual solution is at the top
 *
 * @author lewin
 */
public class andpermutation_lewin {
    public static void main(String[] args) {
        InputStream inputStream = System.in;
        OutputStream outputStream = System.out;
        InputReader in = new InputReader(inputStream);
        OutputWriter out = new OutputWriter(outputStream);
        andpermutation solver = new andpermutation();
        solver.solve(1, in, out);
        out.close();
    }

    static class andpermutation {
        public long[] ans;
        public long[] arr;

        public void solve(int testNumber, InputReader in, OutputWriter out) {
            int n = in.nextInt();
            long[] inp = in.readLongArray(n);
            arr = Arrays.copyOf(inp, inp.length);
            AUtils.sort(arr);
            long[] brr = Arrays.copyOf(arr, n);
            ans = new long[arr.length];
            findPermutation(61, 0, n - 1);
            for (long x : inp) {
                out.println(ans[Arrays.binarySearch(brr, x)]);
            }
        }

        public void findPermutation(int n, int start, int end) {
            /**
             * Split the sets into two parts, those that have n and those that don't contain $n$.
             * Solve the problem recursively on both parts (for the subsets that contain $n$, remove $n$ from all of those subsets to get a valid smaller subproblem).
             * Let the solutions to these recursive problems be $x_0$ (for those subsets that don't contain $n$) and $x_1$ (for subsets that do contain $n$).
             *
             * Now, you can reconstruct the answer to the original as follows.
             *
             * For a subset $a$, we can get the answer it based on three cases:
             *
             * - if $n \in a$, then $a$ maps to $x_1(a - {n})$
             * - if $n \not\in a$ and $x_0(a) + {n} \in A$, then $a$ maps to $x_0(a) + {n}$
             * - Otherwise, $a$ maps to $x_0(a)$
             *
             * You can verify that this mapping is a permutation, and the intersection is empty.
             *
             * The time it takes for this is $O(|A|n)$ (since each subset gets processed at most once for each number $i$ from $1$ to $n$).
             */
            if (n == -1 || end <= start) {
                return;
            }
            int split = end;
            for (int i = start; i <= end; i++) {
                if (((arr[i] >> n) & 1) == 1) {
                    split = i - 1;
                    break;
                }
            }
            HashSet<Long> hs = new HashSet<>();
            for (int i = split + 1; i <= end; i++) {
                hs.add(arr[i]);
                arr[i] ^= 1L << n;
            }
            findPermutation(n - 1, start, split);
            findPermutation(n - 1, split + 1, end);
            for (int i = start; i <= split; i++) {
                if (hs.contains(ans[i] ^ (1L << n))) {
                    ans[i] ^= 1L << n;
                }
            }
        }

    }

    static class InputReader {
        private InputStream stream;
        private byte[] buf = new byte[1 << 16];
        private int curChar;
        private int numChars;

        public InputReader(InputStream stream) {
            this.stream = stream;
        }

        public long[] readLongArray(int tokens) {
            long[] ret = new long[tokens];
            for (int i = 0; i < tokens; i++) {
                ret[i] = nextLong();
            }
            return ret;
        }

        public int read() {
            if (this.numChars == -1) {
                throw new UnknownError();
            } else {
                if (this.curChar >= this.numChars) {
                    this.curChar = 0;

                    try {
                        this.numChars = this.stream.read(this.buf);
                    } catch (IOException var2) {
                        throw new InputMismatchException();
                    }

                    if (this.numChars <= 0) {
                        return -1;
                    }
                }

                return this.buf[this.curChar++];
            }
        }

        public int nextInt() {
            int c;
            for (c = this.read(); isSpaceChar(c); c = this.read()) {
                ;
            }

            byte sgn = 1;
            if (c == 45) {
                sgn = -1;
                c = this.read();
            }

            int res = 0;

            while (c >= 48 && c <= 57) {
                res *= 10;
                res += c - 48;
                c = this.read();
                if (isSpaceChar(c)) {
                    return res * sgn;
                }
            }

            throw new InputMismatchException();
        }

        public long nextLong() {
            int c;
            for (c = this.read(); isSpaceChar(c); c = this.read()) {
                ;
            }

            byte sgn = 1;
            if (c == 45) {
                sgn = -1;
                c = this.read();
            }

            long res = 0L;

            while (c >= 48 && c <= 57) {
                res *= 10L;
                res += (long) (c - 48);
                c = this.read();
                if (isSpaceChar(c)) {
                    return res * (long) sgn;
                }
            }

            throw new InputMismatchException();
        }

        public static boolean isSpaceChar(int c) {
            return c == 32 || c == 10 || c == 13 || c == 9 || c == -1;
        }

    }

    static class AUtils {
        public static void sort(long[] arr) {
            for (int i = 1; i < arr.length; i++) {
                int j = (int) (Math.random() * (i + 1));
                if (i != j) {
                    long t = arr[i];
                    arr[i] = arr[j];
                    arr[j] = t;
                }
            }
            Arrays.sort(arr);
        }

    }

    static class OutputWriter {
        private final PrintWriter writer;

        public OutputWriter(OutputStream outputStream) {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        }

        public OutputWriter(Writer writer) {
            this.writer = new PrintWriter(writer);
        }

        public void close() {
            writer.close();
        }

        public void println(long i) {
            writer.println(i);
        }

    }
}
