import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public class jeroenb {
	static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	static Model[] models;

	public static void main(String[] args) throws Exception {
		// Read input
		int n = Integer.valueOf(in.readLine());
		models = new Model[n];
		for (int i = 0; i < n; i++) {
			String[] ps = in.readLine().split(" ");
			models[i] = new Model(Integer.valueOf(ps[0]),
					Integer.valueOf(ps[1]),
					Integer.valueOf(ps[2]));
		}

		// Sort by x, y
		Arrays.sort(models);

		// Init the graph
		adj = new ArrayList[n];
		for (int i = 0; i < n; i++)
			adj[i] = new ArrayList<Integer>();

		// Visit in order, and connect to all later models
		for (int i = 0; i < n; i++) {
			// Loop over x, this is a small set
			int maxd = (models[i].d + 1) / 2 + 80 + 51;
			for (int x = models[i].x; x <= models[i].x + maxd; x++) {
				int dx = models[i].x - x;
				int maxyd = (int) Math.ceil(Math.sqrt((double) maxd * (double) maxd - (double) dx * (double) dx));
				int j = firstIndex(x, x == models[i].x ? models[i].y + 1 : models[i].y - maxyd);
				while (j < n && models[j].x == x && models[j].y < models[i].y + maxyd) {
					if (models[i].inRange(models[j]))
						connect(i, j);
					j++;
				}
			}
		}

		// Now see if the graph is connected
		seen = new boolean[n];
		dfs(0);
		for (int i = 0; i < n; i++) {
			if (!seen[i]) {
				System.out.println("no");
				return;
			}
		}

		// And if we have at least 7 models, check that they have 2 connections
		if (n >= 7) {
			for (int i = 0; i < n; i++) {
				if (adj[i].size() < 2) {
					System.out.println("no");
					return;
				}
			}
		}

		// Everything worked out
		System.out.println("yes");
	}

	static int firstIndex(int x, int y) {
		int low = 0;
		int up = models.length;
		while (low != up) {
			int mid = (low + up) / 2;
			if (models[mid].x < x || (models[mid].x == x && models[mid].y < y))
				low = mid + 1;
			else
				up = mid;
		}
		return low;
	}

	static ArrayList<Integer>[] adj;

	static void connect(int i, int j) {
		adj[i].add(j);
		adj[j].add(i);
	}

	static boolean[] seen;

	static void dfs(int i) {
		if (seen[i])
			return;
		seen[i] = true;
		for(int j : adj[i])
			dfs(j);
	}
}

class Model implements Comparable<Model> {
	public int x, y, d;

	public Model(int x, int y, int d) {
		this.x = x;
		this.y = y;
		this.d = d;
	}

	public int compareTo(Model other) {
		if (x != other.x)
			return x - other.x;
		return y - other.y;
	}

	public boolean inRange(Model other) {
		double dx = x - other.x;
		double dy = y - other.y;
		double dist = Math.sqrt(dx * dx + dy * dy);
		return dist <= 2 * 25.4 + (this.d + other.d) / 2.0;
	}
}
