#!/usr/bin/env python3

from heapq import heappop, heappush


def turncost(row: int) -> int:
    if row == 0:
        return 0
    if 1 <= row <= 4:
        return 1
    return 2


def before(x, y):
    if x == "Q":
        return y >= "U"
    return x <= y


def neighbours(row, col):
    if col == -1:
        return [(r, 0, turncost(r)) for r in range(6)]
    if 0 <= col < 15:
        return [
            (r, col + 1, turncost(r))
            for r in range(6)
            if before(dice[row][col], dice[r][col + 1])
        ]
    return [(16, 0, 0)]


dice = tuple(input() for _ in range(6))

Q: list[tuple[int, tuple[int, int]]] = [(0, (-1, -1))]
seen, dist = set(), {(-1, -1): 0}
while Q:
    cost, u = heappop(Q)
    if u not in seen:
        seen.add(u)
        if u[0] == 16:
            print(cost)
            break
        for row, col, c in neighbours(*u):
            if (row, col) in seen:
                continue
            prev = dist.get((row, col), None)
            if prev is None or cost + c < prev:
                dist[(row, col)] = cost + c
                heappush(Q, (cost + c, (row, col)))
else:
    print("impossible")
