#include <string>
#include <unordered_map>
#include "validation.h"

int main(int argc, char *argv[]) {
    InputValidator v(argc, argv);
    char faces[6][16];
    for (int i = 0; i < 6; ++i) {
	    std::string line = v.read_string("line", 16, 16, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	    for (int j = 0; j < 16; ++j) faces[i][j] = line[j];
	    v.newline();
    }

    // No die can contain the same letter more than thrice:
    for (int col = 0; col < 16; ++col) {
	    std::unordered_map<char, int> freq;
	    for (int row = 0; row < 6; ++row) {
		    char c = faces[row][col];
		    freq[c]++;
		    if (freq[c] > 3) v.WA("Die ", col, " has more than 3 faces with ", c);
	    }
    }

    // There must be exactly one Q 
    int qs = 0;
    for (int col = 0; col < 16; ++col) {
	    for (int row = 0; row < 6; ++row) {
		    if (faces[row][col] == 'Q') ++qs;
	    }
    }

    if (qs != 1) v.WA("Expected exactly one Q face, found", qs);
    return 0;
}
