#!/usr/bin/env python3

import sys


def fail(msg):
    print(msg, file=sys.stderr)
    sys.exit(43)


with open(sys.argv[1]) as infile, open(sys.argv[2]) as ansfile:
    team_output = sys.stdin.read()

    ansfile_first_token = ansfile.read().split()[0]
    is_impossible = ansfile_first_token == 'impossible'
    if is_impossible:
        if team_output.strip().lower() != 'impossible':
            sane_team_output = team_output.rstrip().replace('\n', '\\n')
            if len(sane_team_output) > 80:
                sane_team_output = sane_team_output[:80] + '[...]'
            fail(f"Expected 'impossible', got '{sane_team_output}'")
        else:
            sys.exit(42)  # Team correctly outputs 'impossible'

    # After this, the test case must be possible.

    if 'impossible' in team_output.lower():  # super-lenient about case and spam
        fail("Rejects yes-instance")

    n, m = map(int, map(int, infile.readline().split()))
    edges = [ None ] + [ [] for _ in range(n) ] # ignore entry 0
    for line in infile:
        u, v = map(int, line.split())
        edges[u].append(v)
        edges[v].append(u)

    team_tokens = team_output.split()
    if not team_tokens:
        fail("Team output is empty")

    try:
        r = int(team_tokens[0])
    except ValueError:
        fail(f"Integer expected, got {team_tokens[0]}")

    if len(team_tokens[1:]) != r:
        fail(f"Team promised {r} vertices, but provided {len(team_tokens[1:])}")

    try:
        trip = list(map(int, team_tokens[1:]))
    except ValueError:
        fail(f"Integers expected, got {team_tokens[1:]}")

    if len(trip) == 0:
        fail("Trip must not be empty")
    if trip[0] != 1:
        fail(f"Trip must start at 1, got {trip[0]}")
    if trip[-1] != 1:
        fail(f"Trip must end at 1, got {trip[-1]}")
    if len(set(trip)) == 1:
        fail("Trip must leave home")
    for u, v in zip(trip, trip[1:]):
        if v not in edges[u]:
            fail(f"Trip uses nonexisting edge {u}--{v}")
    for u, v, w in zip(trip, trip[1:], trip[2:]):
        if u == w:
            fail(f"Trip contains digon {u}--{v}--{w}")
    opt = int(ansfile_first_token)
    if len(trip) < opt:
        assert False, f"Fatal error; solver found better answer than judges: {trip}"
    if len(trip) > opt:
        fail(f"Trip valid, but too long {len(trip)} > {opt}")
    sys.exit(42)
