#!/usr/bin/env python3
from collections import Counter
from math import sqrt

"""
Count letter frequencies. For the LLM, the frequency of each letter roughly has a normal distribution
with mean len(s)/26 and standard deviation sqrt( len(s)/26 * 25/26 ).
Now output yes (human) if the minimum letter frequency is
at least 4 standard deviations below the mean, and no (AI) otherwise.
"""

s = input()
freqs = Counter(s).values()
print("yes" if len(freqs) < 26 or min(freqs) <= len(s) / 26 - 4 * sqrt(len(s) / 26 * 25 / 26) else "no")
