#include "validation.h"

using namespace std;

int text_len = 300'000;
int n = 5000;
string alphabet = "abcdefghijklmnopqrstuvwxyz";

int main(int argc, char** argv) {
    ifstream in(argv[1]);

    // Read the input file.
    unsigned int testcase_seed;
    string text_type, word_setting;
    in >> testcase_seed >> text_type;

    // The word list is fixed per test case.
    vector<string> words(n);
    for (int i = 0; i < n; i++) {
        in >> words[i];
    }

    // For test cases where the answer is "yes" (human), the seed is fixed, so the string `s` does not change.
    auto seed = testcase_seed;
    if (text_type == "llm") {
        // For test cases where the answer is "no" (LLM), the seed is randomized for each submission.
        random_device dev; // bt ignore
        auto random_seed = dev();
        seed ^= random_seed;
    }

    cerr << "Seed: " << seed << endl;

    // Generate the team input.
    {
        Generator g(seed);

        if (text_type == "human") {
            for (int i = 0, newI, index; i < text_len; i = newI) {
                do {
                    index = g.gen_integer("index", 0, n - 1);
                    newI = i + words[index].size();
                // This condition should tie up the end in the case of random word length.
                } while (newI == text_len - 11 || text_len - 6 < newI && newI < text_len || newI > text_len);
                g.test_string(words[index]);
            }
        } else if (text_type == "llm") {
            g.read_string("text", text_len, text_len, alphabet);
        } else {
            // If the text_type is not "human" or "LLM", it must be a string of length `n`.
            g.test_string(text_type);
        }
        g.newline();

        g.read_integer("n", n, n);
        g.newline();
        for (string word : words) {
            g.test_string(word);
            g.newline();
        }
    }

    // Validate that the team output matches the expected answer.
    OutputValidator v(argc, argv);
    v.test_string(text_type == "llm" ? "no" : "yes");
    v.newline();
}
