#!/usr/bin/env python3
import random
import string

import sys

# Init seed with first argument
random.seed(int(sys.argv[1]))

w_len = sys.argv[3]
letters = string.ascii_lowercase if len(sys.argv) <= 4 else sys.argv[4]
words = set()
while len(words) < 5000:
    words.add("".join(random.choices(letters, k=random.randint(6, 10) if w_len == "random" else int(w_len))))
words = list(words)
random.shuffle(words)

text_type = sys.argv[2]
if text_type == "round-robin":
    text_type = ''
    while len(text_type) < 3e5:
        random.shuffle(words)
        all_words = ''.join(words)
        text_type += all_words
    text_type = text_type[:int(3e5)]
print(random.randrange(0, 2**32), text_type)
print(*words, sep="\n")
