import matplotlib
import matplotlib.pyplot as plt

##out=[]
##
##out.append("""\tikzset{every picture/.style={line width=0.75pt}} %set default line width to 0.75pt        
##
##\begin{tikzpicture}[x=0.75pt,y=0.75pt,yscale=-1,xscale=1]""")

print("start")
plt.figure(figsize=(6,6))

Z=0
def z():
    global Z
    Z+=1
    return Z

def draw_line(a,b,size,color):
    K=50
    points=[]
    for ux in range(-K//2,30*K+K//2):
        x=ux*1.0/K
        y=(a*x+b+0.5)%31-0.5
        if not points or abs(points[-1][1]-y)<30.1:
            pass
        else:
            points.append((None,None))
        points.append((x,y))
##    print(points)
        
    plt.plot(*zip(*points),c=color,zorder=z())

    dots=[]
    for x in range(31):
        y=(a*x+b)%31
        dots.append((x,y))
    plt.scatter(*zip(*dots),marker="o",c=color,s=size**2,zorder=z())


dots=[]
for x in range(31):
    for y in range(31):
        dots.append((x,y))
plt.scatter(*zip(*dots),c="black",s=8)
##        dot(x,y,"k",5)


draw_line(3,22,8,"red")
draw_line(1,5,6,"blue")

plt.margins(0,0)
plt.axis("off")
plt.gca().set_aspect('equal')
matplotlib.ticker.NullLocator()
plt.subplots_adjust(top = 1, bottom = 0, right = 1, left = 0, 
            hspace = 0, wspace = 0)

plt.savefig("3x+22red_1x+5blue.pdf",bbox_inches='tight',pad_inches = 0)
plt.show()
