#include <iostream>
#include <string>
#include <vector>

struct point{
    int x, y, z;
    point(int x_ = 0, int y_ = 0, int z_ = 0) : x(x_), y(y_), z(z_) {}
    void set_xyz(int x_, int y_, int z_) {x=x_; y=y_; z=z_;}
};

int main(){
    int n;
    std::string hyphen;
    std::cin >> n;
    std::vector<std::vector<std::string>> g(n, std::vector<std::string>(n));
    for (int x = 0; x < n; ++x) {
        std::cin >> hyphen;
        for (int y = 0; y < n; ++y) std::cin >> g[x][y];
    }
    
    std::vector<point> A(n*n*n), P(n*n*n);
    int An = 0, Pn = 0;
    for (int x = 0; x < n; ++x) for (int y = 0; y < n; ++y) for (int z = 0; z < n; ++z){
        switch(g[x][y][z]){
            case 'A':
            A[An++].set_xyz(x,y,z);
            break;
            case 'P':
            P[Pn++].set_xyz(x,y,z);
            break;
        }
    }
    A.resize(An);
    P.resize(Pn);
    
    int N = n-1;
    std::vector<std::vector<std::vector<std::vector<point>>>> perps(N+1, std::vector<std::vector<std::vector<point>>>(2*N+1, std::vector<std::vector<point>>(2*N+1)));
    for (int x = 1; x <= N; ++x) for (int y = -N; y <= N; ++y) for (int z = -N; z <= N; ++z) for (int y2 = -N; y2 <= N; ++y2) for (int z2 = -N; z2 <= N; ++z2){
        int x2 = -(y*y2+z*z2)/x;
        if (x2 >= -N && x2 <= N && x*x2+y*y2+z*z2 == 0) perps[x][y+N][z+N].emplace_back(x2,y2,z2);
    }
    for (int y = -N; y <= N; ++y) for (int z = -N; z <= N; ++z) for (int y2 = -N; y2 <= N; ++y2) for (int z2 = -N; z2 <= N; ++z2)
        if (y*y2+z*z2 == 0) for (int x2 = -N; x2 <= N; ++x2)
            perps[0][y+N][z+N].emplace_back(x2,y2,z2);
    
    long long ans = 0;
    for (const point &a : A) for (const point &p : P){
        int sgn = 1-2*(p.x<a.x);
        point d(sgn*(p.x-a.x),sgn*(p.y-a.y),sgn*(p.z-a.z));
        int bs = 0, cs = 0;
        for (const point &d2 : perps[d.x][d.y+N][d.z+N]){
            point b(a.x+d2.x,a.y+d2.y,a.z+d2.z);
            bs += b.x >= 0 && b.x <= N && b.y >= 0 && b.y <= N && b.z >= 0 && b.z <= N && g[b.x][b.y][b.z] == 'B';
            point c(p.x+d2.x,p.y+d2.y,p.z+d2.z);
            cs += c.x >= 0 && c.x <= N && c.y >= 0 && c.y <= N && c.z >= 0 && c.z <= N && g[c.x][c.y][c.z] == 'C';
        }
        ans += bs * cs;
    }
    std::cout << ans << std::endl;
    
    return 0;
}
