fun main() {
    var n = readln().toInt()
    val g = Array<Array<String>>(n) {
        readln() // read hyphen
        Array<String>(n) { readln() }
    }

    val cap = n * n * n
    val B = List(cap) { Point() }
    val A = List(cap) { Point() }
    val P = List(cap) { Point() }
    val C = List(cap) { Point() }
    var Bn = 0
    var An = 0
    var Pn = 0
    var Cn = 0
    for (x in 0..<n) for (y in 0..<n) for (z in 0..<n) {
        val ch = g[x][y].get(z)
        when (ch) {
            'B' -> B[Bn++].set(x, y, z)
            'A' -> A[An++].set(x, y, z)
            'P' -> P[Pn++].set(x, y, z)
            'C' -> C[Cn++].set(x, y, z)
        }
    }
    // shrink counts by just tracking sizes
    val X = n // will be decremented to n-1 below in C++ code; but arrays use 0..n inclusive length so use N1 = n
    val N1 = n // keep original n for coords
    n = n - 1 // now n matches C++ after --n
    val dimX = n + 1 // 0..n
    val dimY = 2 * n + 1 // -n..n
    val dimZ = 2 * n + 1 // -n..n
    val shift = 2 * n * n
    val dimD = 5 * n * n + 1
    val total = 1L * dimX * dimY * dimZ * dimD
    val size = total.toInt()
    val planesB = IntArray(size)
    val planesC = IntArray(size)

    // index helper
    val fn = n
    val fdimY = dimY
    val fdimZ = dimZ
    val fdimD = dimD
    val fshift = shift
    for (x in 0..n) {
        for (y in -n..n) {
            val yidx = y + n
            for (z in -n..n) {
                val zidx = z + n
                for (i in 0..<Bn) {
                    val b = B[i]
                    val dot = x * b.x + y * b.y + z * b.z + fshift
                    val idx = index(x, yidx, zidx, dot, fdimY, fdimZ, fdimD)
                    planesB[idx]++
                }
                for (i in 0..<Cn) {
                    val c = C[i]
                    val dot = x * c.x + y * c.y + z * c.z + fshift
                    val idx = index(x, yidx, zidx, dot, fdimY, fdimZ, fdimD)
                    planesC[idx]++
                }
            }
        }
    }

    var ans: Long = 0
    for (ia in 0..<An) {
        val a = A[ia]
        for (ip in 0..<Pn) {
            val p = P[ip]
            val sgn = if (p.x < a.x) -1 else 1
            val dx = sgn * (p.x - a.x)
            val dy = sgn * (p.y - a.y)
            val dz = sgn * (p.z - a.z)
            val x = dx
            val yidx = dy + n
            val zidx = dz + n
            val dotA = dx * a.x + dy * a.y + dz * a.z + shift
            val dotP = dx * p.x + dy * p.y + dz * p.z + shift
            val idxA = index(x, yidx, zidx, dotA, dimY, dimZ, dimD)
            val idxP = index(x, yidx, zidx, dotP, dimY, dimZ, dimD)
            ans += 1L * planesB[idxA] * planesC[idxP]
        }
    }
    kotlin.io.println(ans)
}

fun index(x: Int, yidx: Int, zidx: Int, dot: Int, dimY: Int, dimZ: Int, dimD: Int): Int {
    val idx = ((x.toLong() * dimY + yidx) * dimZ + zidx) * dimD.toLong() + dot
    return idx.toInt()
}

internal class Point {
    var x: Int = 0
    var y: Int = 0
    var z: Int = 0

    constructor()

    constructor(x: Int, y: Int, z: Int) {
        this.x = x
        this.y = y
        this.z = z
    }

    fun set(x: Int, y: Int, z: Int) {
        this.x = x
        this.y = y
        this.z = z
    }
}