#include <iostream>
#include <iomanip>
#include <vector>
#include <map>
#include <queue>
#include <algorithm>
#include <utility>
#include <cmath>

using namespace std;

typedef int coord;

class point {
public:
	coord x, y, z;

	point() { x = y = z = 0; }
	point(coord x1, coord y1, coord z1) { x = x1; y = y1; z = z1; }

	point operator +=(point a) { x += a.x; y += a.y; z += a.z; return *this; }
	point operator -=(point a) { x -= a.x; y -= a.y; z -= a.z; return *this; }
};

point operator +(point a, point b) { return a += b; }
point operator -(point a, point b) { return a -= b; }
coord operator *(point a, point b) { return a.x*b.x + a.y*b.y + a.z*b.z; }

bool operator <(point a, point b)
{
	if ( a.x!=b.x ) return a.x<b.x;
	if ( a.y!=b.y ) return a.y<b.y;
	return a.z<b.z;
}

int n;

bool ingrid(point a)
{
	return a.x>=0 && a.x<n && a.y>=0 && a.y<n && a.z>=0 && a.z<n;
}

int main()
{
	cin >> n;

	vector<vector<string>> grid(n, vector<string>(n));

	for(int i=0; i<n; i++) {
		char sep;
		cin >> sep;
		for(int j=0; j<n; j++) cin >> grid[i][j];
	}

	string letters = "BAPC";
	vector<point> letterpos[4];

	for(int i=0; i<letters.length(); i++) {
		for(int x=0; x<n; x++) {
			for(int y=0; y<n; y++) {
				for(int z=0; z<n; z++) {
					if ( grid[x][y][z]==letters[i] ) {
						letterpos[i].push_back(point(x,y,z));
					}
				}
			}
		}
	}

	vector<point> delta;
	for(int x=-n+1; x<n; x++) {
		for(int y=-n+1; y<n; y++) {
			for(int z=-n+1; z<n; z++) {
				delta.push_back(point(x,y,z));
			}
		}
	}

	map<point, vector<point>> perp;
	for(int i=0; i<delta.size(); i++) {
		vector<point> tmp;
		for(int j=0; j<delta.size(); j++) {
			if ( i!=j && delta[i]*delta[j]==0 ) tmp.push_back(delta[j]);
		}
		perp[delta[i]] = tmp;
	}

	long long res = 0;
	for(int i1=0; i1<letterpos[1].size(); i1++) {
		for(int i2=0; i2<letterpos[2].size(); i2++) {
			point dmid = letterpos[2][i2] - letterpos[1][i1];

			long long ba = 0, pc = 0;
			for(point dp : perp[dmid]) {
				point B = letterpos[1][i1] + dp;
				point C = letterpos[2][i2] + dp;
				if ( ingrid(B) && grid[B.x][B.y][B.z]==letters[0] ) ba++;
				if ( ingrid(C) && grid[C.x][C.y][C.z]==letters[3] ) pc++;
			}
			res += ba*pc;
		}
	}

	cout << res << endl;

	return 0;
}
