
#include <iostream>
#include <vector>
#include <unordered_set>
#include <cmath>

const long long MAXX = 10000;

long long icbrt(long long n){
    long long g = n < 0 ? -n : n;
    long long mini = std::cbrtl(g)-1, maxi = std::cbrtl(g)+1;
    while (mini < maxi){
        long long midi = (mini + maxi + 1) / 2;
        if (midi*midi*midi <= g) mini = midi;
        else maxi = midi - 1;
    }
    if (n >= 0) return mini;
    else if (mini*mini*mini == g) return -mini;
    else return -mini - 1;
}

std::vector<long long> try_one(long long n){
    long long r = icbrt(n);
    if (r*r*r == n) return {r};
    return {};
}

std::vector<long long> try_two(long long n){
    for (long long a = -MAXX; a <= MAXX; ++a){
        long long r = icbrt(n - a*a*a);
        if (r >= -MAXX && r <= MAXX && a*a*a + r*r*r == n) return {a, r};
    }
    return {};
}

long long mod_pow(long long n, long long k, long long p){
    if (k == 0) return 1;
    long long nk2 = mod_pow(n, k/2, p);
    return (k % 2 == 1 ? ((n * nk2) % p) * nk2 : nk2 * nk2) % p;
}

const long long MAXD = std::cbrtl(4*(MAXX+MAXX*MAXX*MAXX))+1;
std::vector<long long> mod_log(MAXD+1, -1);
std::vector<long long> mod_cbrt(long long n, long long p){
    n %= p;
    if (n == 0) return {0};
    if (p % 3 == 2) return {mod_pow(n, (2*p-1)/3, p)};
    if (p == 3) return {n};
    std::vector<long long> ds;
    for (long long d = 2; d*d <= p-1; ++d) if ((p-1) % d == 0){
        ds.push_back(d);
        if (d*d < p-1) ds.push_back((p-1) / d);
    }
    long long g = 2;
    while (true){
        bool success = true;
        for (long long d : ds) if (mod_pow(g, d, p) == 1) success = false;
        if (success) break;
        ++g;
    }
    long long gk = 1, k = 0;
    for (; k*k <= p-1; gk = (gk*g)%p, k += 1) mod_log[gk] = k;
    std::vector<long long> ans = {};
    for (long long prod = n, i = 0; ; prod = (prod*gk)%p, i += 1) if (mod_log[prod] != -1){
        long long lg = (((mod_log[prod] - i*k)%(p-1))+(p-1))%(p-1);
        if (lg % 3 != 0) break;
        lg = (lg/3)%((p-1)/3);
        ans = {mod_pow(g, lg, p), mod_pow(g, lg+(p-1)/3, p), mod_pow(g, lg+2*(p-1)/3, p)};
        break;
    }
    gk = 1; k = 0;
    for (; k*k <= p-1; gk = (gk*g)%p, k += 1) mod_log[gk] = -1;
    return ans;
}

long long isqrt(long long n){
    if (n < 0) return -1;
    long long mini = sqrtl(n)-1, maxi = sqrtl(n)+1;
    while (mini < maxi){
        long long midi = (mini + maxi + 1) / 2;
        if (midi*midi <= n) mini = midi;
        else maxi = midi - 1;
    }
    if (mini*mini == n) return mini;
    else return -1;
}

std::vector<long long> fast_sum_of_two(long long n, const std::vector<long long> &pds){
    std::vector<long long> ds = {1};
    for (long long p : pds){
        long long prev_dss = ds.size();
        for (long long pk = p; n % pk == 0; pk *= p) for (long long i = 0; i < prev_dss; ++i) ds.push_back(ds[i] * pk);
    }
    for (long long m : ds){
        if ((m*m - n/m) % 3 != 0) continue;
        long long ell = (m*m - n/m) / 3;
        long long r = isqrt(m*m - 4*ell);
        if (r*r != m*m - 4*ell) continue;
        long long r1 = (m-r)/2, r2 = (m+r)/2;
        if (r1 >= -MAXX && r1 <= MAXX && r2 >= -MAXX && r2 <= MAXX) return {r1, r2};
    }
    return {};
}

std::vector<long long> try_three(long long n){
    std::vector<bool> prime(MAXD+1, true);
    prime[0] = prime[1] = false;
    std::vector<std::vector<long long>> pds(2*MAXX+1);
    for (long long p = 2; p <= MAXD; ++p) if (prime[p]){
        for (long long k = 2; k*p <= MAXD; ++k) prime[k*p] = false;
        for (long long r : mod_cbrt(n, p)){
            for (long long x = r; x <= MAXX; x += p) pds[x + MAXX].push_back(p);
            for (long long x = r-p; x >= -MAXX; x -= p) pds[x + MAXX].push_back(p);
        }
    }
    for (long long x_ = 0; x_ <= MAXX; ++x_) for (long long x = -x_; x <= x_; x += (x_ == 0 ? 1 : 2*x_)){
        if (n - x*x*x >= 0){
            std::vector<long long> rs = fast_sum_of_two(n - x*x*x, pds[x + MAXX]);
            if (!rs.empty()) return {x, rs[0], rs[1]};
        }
        else{
            std::vector<long long> rs = fast_sum_of_two(x*x*x - n, pds[x + MAXX]);
            if (!rs.empty()) return {x, -rs[0], -rs[1]};
        }
    }
    return {};
}

std::vector<long long> try_four(long long n){
    std::unordered_set<long long> seen;
    for (long long a_ = 0; a_ <= MAXX; ++a_) for (long long b_ = 0; b_ <= a_; ++b_) for (long long a = -a_; a <= a_; a += (a_ == 0 ? 1 : 2*a_)) for (long long b = -b_; b <= b_; b += (b_ == 0 ? 1 : 2*b_)){
        seen.insert(a*a*a + b*b*b);
        if (seen.count(n - a*a*a - b*b*b)){
            std::vector<long long> rs = try_two(n - a*a*a - b*b*b);
            return {rs[0], rs[1], a, b};
        }
    }
    return {};
}

long long ones = 0, twos = 0, threes = 0, fours = 0;
std::vector<long long> solve(long long n){
    std::vector<long long> solution = try_one(n);
    if (!solution.empty()){
        ++ones;
        return solution;
    }
    solution = try_two(n);
    if (!solution.empty()){
        ++twos;
        return solution;
    }
    solution = try_three(n);
    if (!solution.empty()){
        ++threes;
        return solution;
    }
    ++fours;
    return try_four(n);
}

void run(long long n){
    std::vector<long long> solution = solve(n);
    std::cout << solution.size();
    for (long long x : solution) std::cout << ' ' << x;
    std::cout << std::endl;
}

int main(){
    long long n;
    std::cin >> n;
    run(n);
    return 0;
}
