import java.io.*;
import java.util.*;

public class ThoreGreedy {
    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        String[] firstLine = br.readLine().split(" ");
        int n = Integer.parseInt(firstLine[0]);
        int w = Integer.parseInt(firstLine[1]);

        int[] rates = new int[n];
        int[] times = new int[n];

        for (int i = 0; i < n; i++) {
            String[] parts = br.readLine().split(" ");
            rates[i] = Integer.parseInt(parts[0]);
            times[i] = Integer.parseInt(parts[1]);
        }

        // Sort mills by time using index mapping
        Integer[] indices = new Integer[n];
        for (int i = 0; i < n; i++) indices[i] = i;

        Arrays.sort(indices, Comparator.comparingInt(i -> times[i]));

        int[] sortedRates = new int[n];
        int[] sortedTimes = new int[n];
        for (int i = 0; i < n; i++) {
            sortedRates[i] = rates[indices[i]];
            sortedTimes[i] = times[indices[i]];
        }

        double[] totalProcessing = new double[n];
        totalProcessing[0] = sortedRates[0];
        for (int i = 1; i < n; i++)
            totalProcessing[i] = totalProcessing[i - 1] + sortedRates[i];

        double prevTime = 0.0;
        double prevWheat = 0.0;
        double minTime = Double.MAX_VALUE;

        for (int i = 0; i < n; i++) {
            double travelTime = 2.0 * sortedTimes[i];

            if (i > 0) {
                prevWheat += (travelTime - prevTime) * totalProcessing[i - 1];
            }

            prevTime = travelTime;
            double time = travelTime;

            if (w > prevWheat) {
                time += (w - prevWheat) / totalProcessing[i];
            }

            minTime = Math.min(minTime, time);
        }

        System.out.printf("%.10f\n", minTime);
    }
}

