### Greedy after mill distance

from itertools import accumulate

n, w = map(int, input().split())

# nearest mill first
mills = sorted((tuple(map(int, input().split())) for _ in range(n)), key=lambda x: x[1])

# total_processing[i] = how much can be processed per hour with *all* mills 0..i
total_processing = list(accumulate(p for p, _ in mills))

# The time spent travelling to the previous mill(s) and the total wheat produced 
# (at even earlier mills) while traveling there
prev_t = prev_wheat = 0

totals = []
for i, t in enumerate(2 * t for _, t in mills):
    # assume we use mills 0, ..., i

    if i > 0:
        prev_wheat += (t - prev_t) * total_processing[i-1]

    prev_t = time = t
    if w > prev_wheat:
        # If there's wheat left to process, all mills 0..i can now work
        time += (w - prev_wheat) / total_processing[i]
    totals.append(time)

print(min(totals))


