fun getPath(trip: MutableList<Int>, adj: MutableList<MutableList<Int>>, parent: IntArray, v: Int) {
    var cur = v
    while (parent[cur] != cur) {
        trip.add(cur)
        cur = parent[cur]
    }
    trip.add(cur)
}

fun main() {
    val (n, m) = readln().split(" ").map { it.toInt() }
    val adj = MutableList<MutableList<Int>>(n) {
        mutableListOf<Int>()
    }
    for (i in 0..<m) {
        val (u, v) = readln().split(" ").map { it.toInt() - 1 }
        adj[u].add(v)
        adj[v].add(u)
    }
    val INF = 1_000_000_000
    val dist = IntArray(n) { INF }
    val parent = IntArray(n) { -1 }
    dist[0] = 0
    parent[0] = 0
    var res = INF
    var v1 = -1
    var v2 = -1
    val q = ArrayDeque<Int>()
    q.add(0)
    while (!q.isEmpty()) {
        val cur: Int = q.removeFirst()
        for (neighL in adj.get(cur)) {
            val neigh = neighL.toInt()
            if (parent[neigh] == -1) {
                q.add(neigh)
                parent[neigh] = cur
                dist[neigh] = dist[cur] + 1
            } else if (neigh == parent[cur]) {
                // continue
            } else if (dist[neigh] + 1 + dist[cur] < res) {
                res = dist[neigh] + 1 + dist[cur]
                v1 = cur
                v2 = neigh
            }
        }
    }
    if (v1 == -1) {
        println("impossible")
        return
    }
    val trip = mutableListOf<Int>()
    getPath(trip, adj, parent, v1)
    trip.reverse()
    getPath(trip, adj, parent, v2)
    println(trip.size)
    println(trip.map { it + 1 }.joinToString(" "))
}