import itertools

n = int(input())
fi = list(map(int, input().split()))
ti = list(map(int, input().split()))

M = 2000000

ds = []
last_floor = 0
for i in range(n - 1):
    if last_floor <= fi[i] <= fi[i + 1] or last_floor >= fi[i] >= fi[i + 1]:
        ds.append(ti[i])
    else:
        ds.append(-(M - 2 * fi[i]) + ti[i])
        # ds.append(M - (ti[i] + M - 2 * fi[i]))

    last_floor = fi[i]
ds = sorted(list(set(ds)))
if not ds:
    ds = [0]
# print(ds)

# be at pos=M-600k at t=600k+50k
# start at 0 at t-pos = (M-600k)-(600k+50k) = M-1.25M = -750k
#

# lf  f
# ---->
# ----------------|
#     <-----------|


# Four lifts: ABCD
# Lift A goes at t=0
# lift BCD variable
# 6 deltas:
# 0   1   2   3   4   5
# AB, AC, AD, BC, BD, CD
# A spanning tree of 3 of the deltas must equal a ti difference.

edges = [(0, 1), (0, 2), (0, 3), (1, 2), (1, 3), (2, 3)]

# Enumerate spanning trees: all but the 4 triangles.
trees = []
for e1, e2, e3 in itertools.combinations(range(6), 3):
    used = set()
    for e in (e1, e2, e3):
        used.add(edges[e][0])
        used.add(edges[e][1])
    if len(used) == 4:
        trees.append((edges[e1], edges[e2], edges[e3]))

# (6 choose 3) - 4 = 16
assert len(trees) == 16

# For each tree, try all possible assignments of deltas from ti for the three edges.

# 16*35*35*35 options = 686000
# total complexity: (16*35*35*35)*35*4 = 96 million
best_time = 10**18
for tree in trees:
    for d1 in ds:
        for d2 in ds:
            for d3 in ds:
                dds = [d1, d2, d3]
                ts = [0, None, None, None]
                done = 0
                while done < 3:
                    for u, v in tree:
                        if (ts[u] == None) ^ (ts[v] == None):
                            if ts[v] == None:
                                ts[v] = ts[u] + dds[done]
                            else:
                                ts[u] = ts[v] - dds[done]
                            done += 1
                # print("new", tree, ds, ts)
                time = 0
                floor = 0
                for f, t in zip(fi, ti):
                    # Find the first elevator going from `floor` to `f`.
                    if f > floor:
                        target_floor = floor
                    else:
                        target_floor = M - floor
                    first_at_target = 10**9
                    # Want to be at `target_floor` at `time`
                    for i in range(4):
                        # start with delay of ts[i].
                        at_target = (target_floor + ts[i] - time) % M
                        # print(
                        #     f"target floor {target_floor} time {time} elevator {i} ts {ts[i]} wait {at_target}"
                        # )
                        first_at_target = min(first_at_target, at_target)
                    time += first_at_target
                    time += abs(floor - f)
                    time += t
                    # print(
                    #     f"process {f}, {t} => target {target_floor} wait {first_at_target} total time {time}"
                    # )
                    floor = f
                # print("final time", time, "\n")
                best_time = min(best_time, time)

print(best_time)
