#include "validation.h"

// Read the test case's input and answer files.
// If the team outputs "impossible", this should match the answer file.
// Else, the team should output two distinct integers a and b originating from two distinct sets S_i and S_j.
// If the team outputs a valid solution but the answer file says "impossible", this results in a Judge Error.

int main(int argc, char* argv[]) {
    // Set up the input and answer streams.
    std::ifstream in(argv[1]);
    std::ifstream ans(argv[2]); // Only for custom checker.
    bool JudgeFound = ans.peek() != 'i';
    // std::string tmp; ans >> tmp; // just for debug purposes
    // std::cerr << tmp  << '\n';
    OutputValidator v(argc, argv);

    int n;
    in >> n;
    std::vector<std::vector<int>> S(n);
    for(int i = 0; i < n; ++i) {
        auto& v = S[i];
        int k;
        in >> k;
        v.resize(k);
        for(int& x : v) {
            in >> x;
        }
    }

    if(v.peek('i')) {
        v.test_string("impossible");
        v.newline();
        v.check(!JudgeFound, "Team didn't find solution while judge solution did");
    } else {

        int a = v.read_integer("a", 1, int(1e9));
        v.space();
        int b = v.read_integer("b", 1, int(1e9));
        v.space();
        v.check(a != b, "a and b should not be equal");

        int i = v.read_integer("i", 1, n);
        v.space();
        int j = v.read_integer("j", 1, n);
        v.newline();
        v.check(i != j, "i and j should not be equal");

        std::cerr << "Team output: " << a << " " << b << " " << i << " " << j << std::endl;

        // check that a ∈ S_i and b ∈ S_j
        v.check(count(S[i - 1].begin(), S[i - 1].end(), a), "a should be an element of S_i");
        v.check(count(S[j - 1].begin(), S[j - 1].end(), b), "b should be an element of S_j");
        // check that a, b ∈ S_i ∩ S_j
        v.check(count(S[i - 1].begin(), S[i - 1].end(), b), "b should be an element of S_j");
        v.check(count(S[j - 1].begin(), S[j - 1].end(), a), "a should be an element of S_i");

        // It is a Judge Error when the answer file is "impossible", but the team found a valid solution.
        assert(JudgeFound);
    }
}
