#include "validation.h"

// One line with an integer n, the number of sets.
// n lines, each with a set: one integer k, followed by k integers.

const int max_n = 50'000;
const int max_k = 100'000;

int main(int argc, char* argv[]) {
    InputValidator v(argc, argv);
    int n = v.read_integer("n", 2, max_n);
    v.newline();

    long long total_k = 0;
    for(int i = 0; i < n; ++i) {
        int k = v.read_integer("k", 2, max_k - 2);
        total_k += k;
        v.space();
        v.read_integers("x", k, 1, int(1e9),Unique);
    }
    v.check(total_k <= max_k, "The sum of sizes of sets must be at most ", max_k, " but is ", total_k);
}
