import kotlin.math.sqrt

const val BASE = 1000000007L

fun main() {
    val n = readln().toInt()
    val L = sqrt(n.toDouble()).toInt()
    val sets = List(n) { readln().split(" ").drop(1).map { it.toInt() } }
    val pairs = mutableMapOf<Long, Int>()

    for (i in 0 until n) {
        if (sets[i].size <= L) {
            val sortedSet = sets[i].sorted()
            for (j1 in sortedSet.indices) {
                for (j2 in j1 + 1 until sortedSet.size) {
                    val x = sortedSet[j1].toLong() + BASE * sortedSet[j2]
                    if (pairs.containsKey(x)) {
                        println("${sortedSet[j1]} ${sortedSet[j2]} ${pairs[x]!! + 1} ${i + 1}")
                        return
                    }
                    pairs[x] = i
                }
            }
        } else {
            val xs = sets[i].toSet()
            for (j in 0 until n) {
                if (i != j) {
                    val overlap = sets[j].filter { it in xs }
                    if (overlap.size >= 2) {
                        println("${overlap[0]} ${overlap[1]} ${j + 1} ${i + 1}")
                        return
                    }
                }
            }
        }
    }
    println("impossible")
}

