#!/usr/bin/env python3

import random
from argparse import ArgumentParser
from collections import defaultdict
parser = ArgumentParser(
        description="Randomly fill a rectangle with models until you give up"
)

parser.add_argument("--attempts", type=int, default=100)
parser.add_argument("--width", type=int, default=10**9)
parser.add_argument("--height", type=int, default=10**9)
parser.add_argument("--seed", type=int)

args = parser.parse_args()
random.seed(args.seed)



models: dict[tuple[int, int], list[tuple[int, int, int]]] = defaultdict(list)

def overlaps(x, y, diameter):
    circles = set()
    for dx in [-1,0,1]:
        for dy in [-1,0,1]:
            circles.update(models[x//400 + dx, y//400 + dy])
    return any( (x - x_)**2 + (y - y_)**2 < ((diameter + d_)/2)**2 for x_, y_, d_ in circles)

for diam in reversed([25, 28, 32, 40, 50, 65, 80, 90, 100, 130, 160]):
    if diam >= args.width or diam >= args.height:
        continue
    for _ in range(args.attempts):
        x = random.randrange(1 + diam//2, args.width - 1 - diam//2)
        y = random.randrange(1 + diam//2, args.height - 1 - diam//2)
        if not overlaps(x,y,diam):
            models[x//400, y//400] += [(x,y,diam)]

all_models = [m for bucket in models.values() for m in bucket]
print(len(all_models))
for m in all_models:
    print(*m)
