#include <cmath>
#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <vector>

const long double q = 50.8;
const int w = 211, wx = 200000;

struct model{
    long long x, y;
    long double r;
    int i;
    bool is_close(const model &m) const {return sqrtl((x-m.x)*(x-m.x)+(y-m.y)*(y-m.y)) < r+m.r+q;}
};

int main(){
    int n;
    std::cin >> n;
    std::unordered_map<long long, std::vector<model>> buckets;
    for (int i = 0; i < n; ++i){
        model m;
        std::cin >> m.x >> m.y >> m.r;
        m.r /= 2;
        m.i = i;
        long long xi = m.x / w, yi = m.y / w;
        buckets[xi * wx + yi].push_back(m);
        buckets[(xi + 1) * wx + yi].push_back(m);
        buckets[xi * wx + yi + 1].push_back(m);
        buckets[(xi + 1) * wx + yi + 1].push_back(m);
    }
    std::vector<std::unordered_set<int>> g(n);
    for (const std::pair<long long, std::vector<model>> b : buckets){
        int bc = b.second.size();
        for (int i = 0; i < bc; ++i) for (int j = i + 1; j < bc; ++j) if (b.second[i].is_close(b.second[j])){
            g[b.second[i].i].insert(b.second[j].i);
            g[b.second[j].i].insert(b.second[i].i);
        }
    }
    if (n >= 7){
        for (int i = 0; i < n; ++i) if (g[i].size() <= 1){
            std::cout << "no" << std::endl;
            return 0;
        }
    }
    std::vector<bool> reach(n);
    std::vector<int> todo(1);
    reach[0] = true;
    int done = 1;
    while (!todo.empty()){
        int i = todo.back();
        todo.pop_back();
        for (int j : g[i]) if (!reach[j]){
            todo.push_back(j);
            reach[j] = true;
            ++done;
        }
    }
    std::cout << (done == n ? "yes" : "no") << std::endl;
    return 0;
}
