#!/usr/bin/env python3
from collections import defaultdict

n = int(input())
# Double the centre coordinates, so diameter becomes radius
models = [(2 * x, 2 * y, d) for x, y, d in (map(int, input().split()) for _ in range(n))]
D = max(d for _, _, d in models) + 102
sparse_grid = defaultdict(lambda: defaultdict(set))
for i, (x, y, d) in enumerate(models):
    for dx in (-d, d):
        for dy in (-d, d):
            sparse_grid[(x + dx) // D][(y + dy) // D].add((i, x, y, d))

graph = []
for i, (x, y, r) in enumerate(models):
    xd, yd = x // D, y // D
    other_models = set(
        (j, xx, yy, rr)
        for xdd in range((x - r - 102) // D, (x + r + 102) // D + 1)
        for ydd in range((y - r - 102) // D, (y + r + 102) // D + 1)
        for j, xx, yy, rr in sparse_grid[xdd][ydd]
        if i != j
    )
    neighs = [j for j, xx, yy, rr in other_models if (x - xx) ** 2 + (y - yy) ** 2 <= (r + rr + 101) ** 2]
    if len(neighs) < 1 + (n >= 7):
        exit(print("no"))
    graph.append(neighs)

stack = [0]
visited = [True] + [False] * (n - 1)
while stack:
    curr = stack.pop()
    for neigh in graph[curr]:
        if not visited[neigh]:
            visited[neigh] = True
            stack.append(neigh)

print("yes" if sum(visited) == n else "no")
