#!/usr/bin/env python3

import random
from argparse import ArgumentParser
from collections import defaultdict

parser = ArgumentParser(
    description="Put models neatly in a grid, with 2.5cm of space between them"
)

parser.add_argument(
    "--incoherent", action="store_true", help="Remove a random internal row or column"
)
parser.add_argument(
    "--noise", action="store_true", help="Move models by a millimeter in each direction"
)
parser.add_argument(
    "--plant",
    action="store_true",
    help="Plant an isolated model somewhere in the middle",
)
parser.add_argument("--rows", type=int, default=10)
parser.add_argument("--columns", type=int, default=10)
parser.add_argument("--diam", type=int, default=25)
parser.add_argument("--seed", type=int)

args = parser.parse_args()
random.seed(args.seed)

assert args.diam in [25, 28, 32, 40, 50, 65, 80, 90, 100, 130, 160]
DISTANCE = 2 * 25  # just below 2*25.4

N = args.rows * args.columns
forbiddencol = forbiddenrow = -1
if args.incoherent:
    if random.randrange(2) == 0:
        forbiddencol = random.randrange(1, args.columns - 1)
        N -= args.columns
    else:
        forbiddenrow = random.randrange(1, args.rows - 1)
        N -= args.rows

if args.plant:
    lonelymodel = random.randrange(1, args.columns - 1), random.randrange(
        1, args.rows - 1
    )
    N -= 8

print(N)
for r in range(args.rows):
    for c in range(args.columns):
        if r == forbiddenrow or c == forbiddencol:
            continue
        if args.plant:
            if (
                c in (lonelymodel[0] - 1, lonelymodel[0], lonelymodel[0] + 1)
                and r in (lonelymodel[1] - 1, lonelymodel[1], lonelymodel[1] + 1)
                and (c, r) != lonelymodel
            ):
                continue
        delta_x = delta_y = 0
        if args.noise:
            delta_x = random.choice([-1, 0, +1])
            delta_y = random.choice([-1, 0, +1])
        print(
            2 + args.diam // 2 + int(c * (args.diam + DISTANCE)) + delta_x,
            2 + args.diam // 2 + int(r * (args.diam + DISTANCE)) + delta_y,
            args.diam,
        )
